/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client.menu;

import com.igteam.immersivegeology.client.menu.ItemSubGroup;
import com.igteam.immersivegeology.common.item.helper.IGFlagItem;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.registration.IGRegistrationHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class IGItemGroup
extends CreativeModeTab {
    private static final ResourceLocation GEOLOGIC_BACKGROUND_TEXTURES = new ResourceLocation("immersivegeology", "textures/gui/creative_tabs/backgrounds/geologic.png");
    private static final ResourceLocation PRODUCT_BACKGROUND_TEXTURES = new ResourceLocation("immersivegeology", "textures/gui/creative_tabs/backgrounds/product.png");
    private static final ResourceLocation PYROMETALLURGY_BACKGROUND_TEXTURES = new ResourceLocation("immersivegeology", "textures/gui/creative_tabs/backgrounds/pyrometallurgy.png");
    private static final ResourceLocation HYDROMETALLURGY_BACKGROUND_TEXTURES = new ResourceLocation("immersivegeology", "textures/gui/creative_tabs/backgrounds/hydrometallurgy.png");
    private static final ResourceLocation STRUCTURAL_BACKGROUND_TEXTURES = new ResourceLocation("immersivegeology", "textures/gui/creative_tabs/backgrounds/structural.png");
    private static final ResourceLocation GEOLOGIC_TAB_TEXTURES = new ResourceLocation("immersivegeology", "textures/gui/creative_tabs/tabs/geologic.png");
    private static final ResourceLocation COMPONENT_TAB_TEXTURES = new ResourceLocation("immersivegeology", "textures/gui/creative_tabs/tabs/component.png");
    private static final ResourceLocation PYRO_TAB_TEXTURES = new ResourceLocation("immersivegeology", "textures/gui/creative_tabs/tabs/pyro.png");
    private static final ResourceLocation HYDRO_TAB_TEXTURES = new ResourceLocation("immersivegeology", "textures/gui/creative_tabs/tabs/hydro.png");
    private static final ResourceLocation STRUCTURAL_TAB_TEXTURES = new ResourceLocation("immersivegeology", "textures/gui/creative_tabs/tabs/structural.png");
    public static ItemSubGroup selectedGroup = ItemSubGroup.geologic;
    static Collection<ItemStack> ret = ItemStackLinkedSet.m_261170_();
    static Collection<ItemStack> dis = ItemStackLinkedSet.m_261170_();
    private static boolean updateRet = true;

    public IGItemGroup(CreativeModeTab.Builder builder) {
        super(builder.withSearchBar(62));
        ret.addAll(this.m_261235_());
    }

    @NotNull
    public ResourceLocation getBackgroundLocation() {
        switch (selectedGroup) {
            case geologic: {
                return GEOLOGIC_BACKGROUND_TEXTURES;
            }
            case components: {
                return PRODUCT_BACKGROUND_TEXTURES;
            }
            case pyrometallurgy: {
                return PYROMETALLURGY_BACKGROUND_TEXTURES;
            }
            case hydrometallurgy: {
                return HYDROMETALLURGY_BACKGROUND_TEXTURES;
            }
            case structural: {
                return STRUCTURAL_BACKGROUND_TEXTURES;
            }
        }
        return GEOLOGIC_BACKGROUND_TEXTURES;
    }

    @NotNull
    public Component m_40786_() {
        return Component.m_237115_((String)"itemGroup.immersivegeology");
    }

    public int getLabelColor() {
        return super.getLabelColor();
    }

    @NotNull
    public ResourceLocation getTabsImage() {
        if (selectedGroup == ItemSubGroup.geologic) {
            return GEOLOGIC_TAB_TEXTURES;
        }
        if (selectedGroup == ItemSubGroup.components) {
            return COMPONENT_TAB_TEXTURES;
        }
        if (selectedGroup == ItemSubGroup.pyrometallurgy) {
            return PYRO_TAB_TEXTURES;
        }
        if (selectedGroup == ItemSubGroup.hydrometallurgy) {
            return HYDRO_TAB_TEXTURES;
        }
        if (selectedGroup == ItemSubGroup.structural) {
            return STRUCTURAL_TAB_TEXTURES;
        }
        return GEOLOGIC_TAB_TEXTURES;
    }

    public static void updateSubGroup(ItemSubGroup group) {
        selectedGroup = group;
        updateRet = true;
        ret.clear();
    }

    @NotNull
    public Collection<ItemStack> m_260957_() {
        if (updateRet) {
            HashMap itemMap = new HashMap();
            for (Item item : IGRegistrationHolder.getIGItems()) {
                ArrayList list;
                if (!(item instanceof IGFlagItem)) continue;
                IGFlagItem iGFlagItem = (IGFlagItem)item;
                IFlagType<?> pattern = iGFlagItem.getFlag();
                if (iGFlagItem.getSubGroup() != selectedGroup) continue;
                if (itemMap.containsKey(pattern)) {
                    list = (ArrayList)itemMap.get(pattern);
                    list.add(item);
                    itemMap.replace(pattern, list);
                    continue;
                }
                list = new ArrayList();
                list.add(item);
                itemMap.put(pattern, list);
            }
            ArrayList<ItemCategoryFlags> allPatternList = new ArrayList<ItemCategoryFlags>(Arrays.asList(ItemCategoryFlags.values()));
            allPatternList.addAll(Arrays.asList(BlockCategoryFlags.values()));
            for (IFlagType iFlagType : allPatternList) {
                if (!itemMap.containsKey(iFlagType)) continue;
                ArrayList list = (ArrayList)itemMap.get(iFlagType);
                for (Item item : list) {
                    ItemStack stack = new ItemStack((ItemLike)item);
                    ret.add(stack);
                }
            }
        }
        return ret;
    }

    @NotNull
    public Collection<ItemStack> m_261235_() {
        if (dis.isEmpty()) {
            HashMap itemMap = new HashMap();
            for (Item item : IGRegistrationHolder.getIGItems()) {
                ArrayList list;
                if (!(item instanceof IGFlagItem)) continue;
                IGFlagItem iGFlagItem = (IGFlagItem)item;
                IFlagType<?> pattern = iGFlagItem.getFlag();
                if (itemMap.containsKey(pattern)) {
                    list = (ArrayList)itemMap.get(pattern);
                    list.add(item);
                    itemMap.replace(pattern, list);
                    continue;
                }
                list = new ArrayList();
                list.add(item);
                itemMap.put(pattern, list);
            }
            ArrayList<ItemCategoryFlags> allPatternList = new ArrayList<ItemCategoryFlags>(Arrays.asList(ItemCategoryFlags.values()));
            allPatternList.addAll(Arrays.asList(BlockCategoryFlags.values()));
            for (IFlagType iFlagType : allPatternList) {
                if (!itemMap.containsKey(iFlagType)) continue;
                ArrayList list = (ArrayList)itemMap.get(iFlagType);
                for (Item item : list) {
                    dis.add(new ItemStack((ItemLike)item));
                }
            }
        }
        return dis;
    }

    public static ItemSubGroup getCurrentSubGroup() {
        return selectedGroup;
    }
}

