/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client.renderer.multiblocks;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import com.igteam.immersivegeology.client.renderer.IGBlockEntityRenderer;
import com.igteam.immersivegeology.common.block.multiblocks.logic.GravitySeparatorLogic;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.SeparatorProcess;
import com.igteam.immersivegeology.common.config.IGClientConfig;
import com.igteam.immersivegeology.common.particle.IGParticles;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SeparatorRenderer
extends IGBlockEntityRenderer<MultiblockBlockEntityMaster<GravitySeparatorLogic.State>> {
    private ItemStack renderStack = ItemStack.f_41583_;
    Random rand = new Random();

    public void render(MultiblockBlockEntityMaster<GravitySeparatorLogic.State> tile, float pPartialTick, PoseStack poseStack, @NotNull MultiBufferSource buffer, int pPackedLight, int pPackedOverlay) {
        boolean doRendering = (Boolean)IGClientConfig.doSpecialRenderGravitySeparator.get();
        if (!doRendering) {
            return;
        }
        IMultiblockBEHelperMaster helper = tile.getHelper();
        IMultiblockContext context = helper.getContext();
        MultiblockOrientation orientation = context.getLevel().getOrientation();
        GravitySeparatorLogic.State state = (GravitySeparatorLogic.State)context.getState();
        boolean hasWater = !state.tank.isEmpty();
        ArrayList<SeparatorProcess> processList = state.separatorProcessesQueue;
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        if (processList.isEmpty()) {
            return;
        }
        BlockPos pos = tile.m_58899_();
        Level level = tile.m_58904_();
        Direction dir = orientation.front();
        boolean isActive = state.shouldRenderActive();
        if (level == null && !isActive) {
            return;
        }
        assert (level != null);
        poseStack.m_85836_();
        SeparatorRenderer.rotateForFacing(poseStack, dir);
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 4.5f, 0.5f);
        if (hasWater && level.m_46467_() % 5L == 0L) {
            level.m_7106_((ParticleOptions)IGParticles.FLOWING_WATER.get(), (double)((float)pos.m_123341_() + 0.5f + this.rand.nextFloat(-0.25f, 0.25f)), (double)((float)pos.m_123342_() + 5.25f + this.rand.nextFloat(-0.25f, 0.25f)), (double)((float)pos.m_123343_() + 1.05f), 0.0, (double)-0.06f, (double)0.1f);
        }
        float twists = 11.0f;
        Quaternionf rotationY = new Quaternionf();
        Quaternionf rotationZ = new Quaternionf().rotateAxis(0.5235988f, (Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f));
        Quaternionf rotationX = new Quaternionf().rotateAxis(-1.3962634f, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f));
        for (SeparatorProcess process : processList) {
            float progress = process.getRelativeProcessStep(level);
            this.renderStack = progress > 0.66f ? process.getCurrentOutput() : process.getInput();
            float sin = Mth.m_14031_((float)(progress * twists));
            float cos = Mth.m_14089_((float)(progress * twists));
            float ax = -cos * 0.8f;
            float ay = -3.5f * progress;
            float az = sin * 0.8f;
            float POINT_IN_ROT = (float)Math.toDegrees(Math.atan2(ax, az));
            poseStack.m_85836_();
            poseStack.m_252880_(ax, ay, az);
            rotationY.identity().rotateAxis(POINT_IN_ROT * ((float)Math.PI / 180), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
            poseStack.m_252781_(rotationY);
            poseStack.m_252781_(rotationZ);
            poseStack.m_252781_(rotationX);
            itemRenderer.m_269128_(this.renderStack, ItemDisplayContext.GROUND, pPackedLight, pPackedOverlay, poseStack, buffer, level, 0);
            poseStack.m_85849_();
            if (level.m_46467_() % 10L != 0L || !hasWater) continue;
            level.m_7106_((ParticleOptions)IGParticles.FLOWING_WATER.get(), (double)((float)pos.m_123341_() + az + 0.4f + this.rand.nextFloat(-0.2f, 0.2f)), (double)((float)pos.m_123342_() + ay + 4.5f + this.rand.nextFloat(-0.2f, 0.2f)), (double)((float)pos.m_123343_() - ax + 0.4f + this.rand.nextFloat(-0.2f, 0.2f)), (double)(ax * 0.05f), (double)-0.001f, (double)(az * 0.05f));
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
    }
}

