/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client.renderer.multiblocks;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import com.igteam.immersivegeology.client.helper.LinkedMultiSkin;
import com.igteam.immersivegeology.client.models.IGDynamicModel;
import com.igteam.immersivegeology.client.renderer.IGBlockEntityRenderer;
import com.igteam.immersivegeology.common.block.multiblocks.IGSteamTurbineMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.logic.SteamTurbineLogic;
import com.igteam.immersivegeology.common.block.multiblocks.part.SteamTurbinePart;
import com.igteam.immersivegeology.common.block.multiblocks.skins.IGSteamTurbineSkins;
import com.igteam.immersivegeology.common.config.IGClientConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@LinkedMultiSkin(multiblock=IGSteamTurbineMultiblock.class)
public class SteamTurbineRenderer
extends IGBlockEntityRenderer<MultiblockBlockEntityMaster<SteamTurbineLogic.State>> {
    public static final String ROTOR_NAME = "steam_turbine_rotor";
    public static IGDynamicModel ROTOR;
    private final Map<String, List<BakedQuad>> quadCache = new HashMap<String, List<BakedQuad>>();

    public void render(MultiblockBlockEntityMaster<SteamTurbineLogic.State> tile, float pPartialTick, PoseStack poseStack, @NotNull MultiBufferSource buffer, int pPackedLight, int pPackedOverlay) {
        boolean doRendering = (Boolean)IGClientConfig.doSpecialRenderSteamTurbine.get();
        if (!doRendering) {
            return;
        }
        IMultiblockBEHelperMaster helper = tile.getHelper();
        IMultiblockContext context = helper.getContext();
        MultiblockOrientation orientation = context.getLevel().getOrientation();
        SteamTurbineLogic.State state = (SteamTurbineLogic.State)context.getState();
        IGSteamTurbineSkins skin = (IGSteamTurbineSkins)((Object)tile.m_58900_().m_61143_(SteamTurbinePart.STEAM_TURBINE));
        float rot = state.getRotation();
        if (state.getTargetRotation() == 0.0f) {
            pPartialTick = 0.0f;
        }
        BlockPos pos = tile.m_58899_();
        Level level = tile.m_58904_();
        Direction dir = orientation.front();
        boolean isMirror = orientation.mirrored();
        poseStack.m_85836_();
        SteamTurbineRenderer.rotateForFacing(poseStack, dir);
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5f, 1.5f);
        poseStack.m_85836_();
        poseStack.m_252781_(new Quaternionf().rotateAxis((rot + pPartialTick) * ((float)Math.PI / 180), (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
        this.renderDynamicModel(ROTOR, poseStack, buffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay, skin);
        poseStack.m_85849_();
        poseStack.m_85849_();
        poseStack.m_85849_();
    }
}

