/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.helper;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiblockCapabilityReference<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiblockCapabilityReference.class);
    protected final Capability<T> cap;

    protected MultiblockCapabilityReference(Capability<T> cap) {
        this.cap = cap;
    }

    @Nullable
    public T getNullable() {
        return null;
    }

    public boolean isPresent() {
        return this.getNullable() != null;
    }

    public static <T> Map<Direction, MultiblockCapabilityReference<T>> forAllNeighbors(BlockEntity local, Capability<T> cap) {
        EnumMap<Direction, MultiblockCapabilityReference<T>> neighbors = new EnumMap<Direction, MultiblockCapabilityReference<T>>(Direction.class);
        for (Direction side : Direction.values()) {
            neighbors.put(side, MultiblockCapabilityReference.forNeighbor(local, cap, side));
        }
        return neighbors;
    }

    public static <T> MultiblockCapabilityReference<T> forNeighbor(BlockEntity local, Capability<T> cap, @Nonnull Direction side) {
        return MultiblockCapabilityReference.forRelative(local, cap, BlockPos.f_121853_.m_121945_(side), side);
    }

    public static <T> MultiblockCapabilityReference<T> forRelative(BlockEntity local, Capability<T> cap, BlockPos offset, Direction side) {
        return MultiblockCapabilityReference.forBlockEntityAt(local, () -> new DirectionalBlockPos(local.m_58899_().m_121955_((Vec3i)offset), side.m_122424_()), () -> new DirectionalBlockPos(local.m_58899_(), side), cap);
    }

    public static <T> MultiblockCapabilityReference<T> forBlockEntityAt(BlockEntity local, Supplier<DirectionalBlockPos> targetPos, Supplier<DirectionalBlockPos> requesterPos, Capability<T> cap) {
        Objects.requireNonNull(local);
        return new MBCapReference<T>(() -> ((BlockEntity)local).m_58904_(), targetPos, requesterPos, cap);
    }

    private static class MBCapReference<T>
    extends MultiblockCapabilityReference<T> {
        private final Supplier<Level> getLevel;
        private final Supplier<DirectionalBlockPos> getTargetPos;
        private final Supplier<DirectionalBlockPos> getRequesterPos;
        @Nonnull
        private LazyOptional<T> currentCap = LazyOptional.empty();
        private DirectionalBlockPos lastTargetPos;
        private DirectionalBlockPos lastRequesterPos;
        private Level lastWorld;
        private BlockEntity lastBE;
        private boolean usingRequesterContext = false;

        public MBCapReference(Supplier<Level> getLevel, Supplier<DirectionalBlockPos> getTargetPos, Supplier<DirectionalBlockPos> getRequesterPos, Capability<T> cap) {
            super(cap);
            this.getLevel = getLevel;
            this.getTargetPos = getTargetPos;
            this.getRequesterPos = getRequesterPos;
        }

        @Override
        @Nullable
        public T getNullable() {
            this.updateLazyOptional();
            return (T)this.currentCap.orElse(null);
        }

        @Override
        public boolean isPresent() {
            this.updateLazyOptional();
            return this.currentCap.isPresent();
        }

        private void updateLazyOptional() {
            Level currWorld = this.getLevel.get();
            DirectionalBlockPos currTargetPos = this.getTargetPos.get();
            DirectionalBlockPos currRequesterPos = this.getRequesterPos.get();
            if (currWorld != null && currTargetPos != null && currRequesterPos != null) {
                if (currWorld != this.lastWorld || !currTargetPos.equals(this.lastTargetPos) || !currRequesterPos.equals(this.lastRequesterPos) || !this.currentCap.isPresent() || this.lastBE != null && this.lastBE.m_58901_()) {
                    if (this.currentCap.isPresent() && this.lastBE != null && this.lastBE.m_58901_()) {
                        LOGGER.warn("The tile entity {} (class {}) was removed, but the value {} provided by it for the capability {} is still marked as valid. This is likely a bug in the mod(s) adding the tile entity/the capability", new Object[]{this.lastBE, this.lastBE.getClass(), this.currentCap.orElseThrow(RuntimeException::new), this.cap.getName()});
                    }
                    this.lastBE = SafeChunkUtils.getSafeBE((LevelAccessor)currWorld, (BlockPos)currTargetPos.position());
                    if (this.lastBE != null) {
                        IMultiblockBE mbe;
                        IMultiblockBEHelper helper;
                        IMultiblockContext context;
                        BlockEntity blockEntity;
                        this.currentCap = this.lastBE.getCapability(this.cap, currTargetPos.side());
                        this.usingRequesterContext = false;
                        Direction side = currRequesterPos.side();
                        if (!this.currentCap.isPresent() && (blockEntity = this.lastBE) instanceof IMultiblockBE && (context = (helper = (mbe = (IMultiblockBE)blockEntity).getHelper()).getContext()) != null) {
                            CapabilityPosition capPos = new CapabilityPosition(helper.getPositionInMB().m_121945_(side.m_122424_()), RelativeBlockFace.from((MultiblockOrientation)context.getLevel().getOrientation(), (Direction)(side.m_122434_().equals((Object)Direction.Axis.Y) ? side.m_122424_() : side)));
                            this.currentCap = helper.getMultiblock().logic().getCapability(context, capPos, ForgeCapabilities.ENERGY);
                            this.usingRequesterContext = true;
                        }
                    } else {
                        this.currentCap = LazyOptional.empty();
                        this.usingRequesterContext = false;
                    }
                    this.lastWorld = currWorld;
                    this.lastTargetPos = currTargetPos;
                    this.lastRequesterPos = currRequesterPos;
                }
            } else {
                this.currentCap = LazyOptional.empty();
                this.lastWorld = null;
                this.lastTargetPos = null;
                this.lastRequesterPos = null;
                this.lastBE = null;
                this.usingRequesterContext = false;
            }
        }

        public boolean isUsingRequesterContext() {
            return this.usingRequesterContext;
        }
    }

    public static class DirectionalBlockPos {
        private final BlockPos position;
        private final Direction side;

        public DirectionalBlockPos(BlockPos position, Direction side) {
            this.position = position;
            this.side = side;
        }

        public BlockPos position() {
            return this.position;
        }

        public Direction side() {
            return this.side;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DirectionalBlockPos)) {
                return false;
            }
            DirectionalBlockPos other = (DirectionalBlockPos)obj;
            return this.position.equals((Object)other.position) && this.side == other.side;
        }

        public int hashCode() {
            return Objects.hash(this.position, this.side);
        }

        public String toString() {
            return "DirectionalBlockPos{pos=" + String.valueOf(this.position) + ", side=" + String.valueOf(this.side) + "}";
        }
    }
}

