/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import com.igteam.immersivegeology.client.models.IGDynamicModel;
import com.igteam.immersivegeology.client.renderer.multiblocks.CoreDrillRenderer;
import com.igteam.immersivegeology.common.block.multiblocks.IGClientMultiblockProperties;
import com.igteam.immersivegeology.common.block.multiblocks.IGTemplateMultiblock;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class IGCoreDrillMultiblock
extends IGTemplateMultiblock {
    public static IGCoreDrillMultiblock INSTANCE = new IGCoreDrillMultiblock();

    public IGCoreDrillMultiblock() {
        super(new ResourceLocation("immersivegeology", "multiblocks/coredrill"), new BlockPos(7, 7, 7), new BlockPos(3, 1, 8), new BlockPos(9, 11, 9), IGMultiblockProvider.COREDRILL);
    }

    public float getManualScale() {
        return 6.0f;
    }

    public void initializeClient(Consumer<ClientMultiblocks.MultiblockManualData> consumer) {
        consumer.accept(new CoredrillClientData(this, 7.5, 7.5, 7.5));
    }

    @Override
    public String getName() {
        return "Core Drill";
    }

    public static class CoredrillClientData
    extends IGClientMultiblockProperties {
        public CoredrillClientData(IGTemplateMultiblock multiblock, double offX, double offY, double offZ) {
            super(multiblock, offX, offY, offZ);
        }

        @Override
        public void renderExtras(PoseStack poseStack, MultiBufferSource buffer) {
            float drill_height = 0.0f;
            float gear_angle = 1.0f;
            float counter_gear_angle = -1.0f;
            float shake = 0.0f;
            Direction dir = Direction.NORTH;
            poseStack.m_85837_(-0.5, 0.0, -0.5);
            boolean flipSupportAngle = false;
            poseStack.m_85836_();
            poseStack.m_85837_(CoreDrillRenderer.DRILL_BIT_OFFSETS.get(dir).m_7096_(), CoreDrillRenderer.DRILL_BIT_OFFSETS.get(dir).m_7098_() + (double)drill_height, CoreDrillRenderer.DRILL_BIT_OFFSETS.get(dir).m_7094_());
            poseStack.m_85836_();
            float angle = 0.0f;
            poseStack.m_252781_(new Quaternionf().rotateAxis(angle * ((float)Math.PI / 180), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
            int pPackedLight = 0xF000F0;
            int pPackedOverlay = OverlayTexture.f_118083_;
            this.renderDynamicModel(CoreDrillRenderer.DRILL_BIT, poseStack, buffer, pPackedLight, pPackedOverlay);
            poseStack.m_85849_();
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85837_(CoreDrillRenderer.DRILL_ENGINE_OFFSETS.get(dir).m_7096_() + (double)shake, CoreDrillRenderer.DRILL_ENGINE_OFFSETS.get(dir).m_7098_() + (double)drill_height, CoreDrillRenderer.DRILL_ENGINE_OFFSETS.get(dir).m_7094_() + (double)shake);
            this.renderDynamicModel(CoreDrillRenderer.DRILL_ENGINE, poseStack, buffer, pPackedLight, pPackedOverlay);
            poseStack.m_85836_();
            poseStack.m_252781_(new Quaternionf().rotateAxis((float)(flipSupportAngle ? -90 : 90) * ((float)Math.PI / 180), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
            poseStack.m_85837_(CoreDrillRenderer.DRILL_SUPPORT_OFFSETS.get(dir).m_7096_(), CoreDrillRenderer.DRILL_SUPPORT_OFFSETS.get(dir).m_7098_(), CoreDrillRenderer.DRILL_SUPPORT_OFFSETS.get(dir).m_7094_());
            this.renderDynamicModel(CoreDrillRenderer.DRILL_ENGINE_SUPPORT, poseStack, buffer, pPackedLight, pPackedOverlay);
            poseStack.m_85837_(CoreDrillRenderer.DRILL_GEAR_OFFSETS.get(dir).get(0).m_7096_(), CoreDrillRenderer.DRILL_GEAR_OFFSETS.get(dir).get(0).m_7098_(), CoreDrillRenderer.DRILL_GEAR_OFFSETS.get(dir).get(0).m_7094_());
            poseStack.m_252781_(new Quaternionf().rotateAxis((float)(flipSupportAngle ? 90 : 0) * ((float)Math.PI / 180), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
            poseStack.m_85836_();
            poseStack.m_85836_();
            poseStack.m_252781_(new Quaternionf().rotateAxis(gear_angle * (float)(flipSupportAngle ? 1 : -1) * ((float)Math.PI / 180), CoreDrillRenderer.DRILL_GEAR_ROTATION_OFFSETS.get(dir)));
            this.renderDynamicModel(CoreDrillRenderer.DRILL_GEARSET, poseStack, buffer, pPackedLight, pPackedOverlay);
            poseStack.m_85849_();
            poseStack.m_85837_(CoreDrillRenderer.DRILL_GEAR_OFFSETS.get(dir).get(1).m_7096_(), CoreDrillRenderer.DRILL_GEAR_OFFSETS.get(dir).get(1).m_7098_(), CoreDrillRenderer.DRILL_GEAR_OFFSETS.get(dir).get(1).m_7094_());
            poseStack.m_85836_();
            poseStack.m_252781_(new Quaternionf().rotateAxis(counter_gear_angle * (float)(flipSupportAngle ? 1 : -1) * ((float)Math.PI / 180), CoreDrillRenderer.DRILL_GEAR_ROTATION_OFFSETS.get(dir)));
            this.renderDynamicModel(CoreDrillRenderer.DRILL_GEARSET, poseStack, buffer, pPackedLight, pPackedOverlay);
            poseStack.m_85849_();
            poseStack.m_85837_(CoreDrillRenderer.DRILL_GEAR_OFFSETS.get(dir).get(2).m_7096_(), CoreDrillRenderer.DRILL_GEAR_OFFSETS.get(dir).get(2).m_7098_(), CoreDrillRenderer.DRILL_GEAR_OFFSETS.get(dir).get(2).m_7094_());
            poseStack.m_85836_();
            poseStack.m_252781_(new Quaternionf().rotateAxis(gear_angle * (float)(flipSupportAngle ? 1 : -1) * ((float)Math.PI / 180), CoreDrillRenderer.DRILL_GEAR_ROTATION_OFFSETS.get(dir)));
            this.renderDynamicModel(CoreDrillRenderer.DRILL_GEARSET, poseStack, buffer, pPackedLight, pPackedOverlay);
            poseStack.m_85849_();
            poseStack.m_85837_(CoreDrillRenderer.DRILL_GEAR_OFFSETS.get(dir).get(3).m_7096_(), CoreDrillRenderer.DRILL_GEAR_OFFSETS.get(dir).get(3).m_7098_(), CoreDrillRenderer.DRILL_GEAR_OFFSETS.get(dir).get(3).m_7094_());
            poseStack.m_85836_();
            poseStack.m_252781_(new Quaternionf().rotateAxis(counter_gear_angle * (float)(flipSupportAngle ? 1 : -1) * ((float)Math.PI / 180), CoreDrillRenderer.DRILL_GEAR_ROTATION_OFFSETS.get(dir)));
            this.renderDynamicModel(CoreDrillRenderer.DRILL_GEARSET, poseStack, buffer, pPackedLight, pPackedOverlay);
            poseStack.m_85849_();
            poseStack.m_85849_();
            poseStack.m_85849_();
            poseStack.m_85849_();
        }

        private void renderDynamicModel(IGDynamicModel model, PoseStack matrix, MultiBufferSource buffer, int light, int overlay) {
            matrix.m_85836_();
            List quads = model.get().getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
            RenderUtils.renderModelTESRFast((List)quads, (VertexConsumer)buffer.m_6299_(RenderType.m_110457_()), (PoseStack)matrix, (int)light, (int)overlay);
            matrix.m_85849_();
        }
    }
}

