/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityDummy;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockPartBlock;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.base.Preconditions;
import com.igteam.immersivegeology.common.block.helper.IGConfigurableMachine;
import com.igteam.immersivegeology.common.item.IGMBFormationItem;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.StoneEnum;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public abstract class IGTemplateMultiblock
extends TemplateMultiblock
implements IGConfigurableMachine {
    private final MultiblockRegistration<?> logic;
    private int formTime = 0;

    public IGTemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin, BlockPos size, MultiblockRegistration<?> logic) {
        super(loc, masterFromOrigin, triggerFromOrigin, size);
        this.logic = logic;
    }

    public boolean createStructure(Level world, BlockPos pos, Direction side, Player player) {
        if (player.m_21205_().m_41720_() instanceof IGMBFormationItem || this.canFormWithDefaultHammer()) {
            return super.createStructure(world, pos, side, player);
        }
        if (IGMBFormationItem.confirmMBStructure(this, world, pos, side, player)) {
            player.m_5661_((Component)Component.m_237115_((String)"immersivegeology.multiblock.formation.failed"), true);
        }
        return false;
    }

    public boolean canFormWithDefaultHammer() {
        return false;
    }

    protected void replaceStructureBlock(StructureTemplate.StructureBlockInfo info, Level world, BlockPos actualPos, boolean mirrored, Direction clickDirection, Vec3i offsetFromMaster) {
        BlockState newState = ((MultiblockPartBlock)this.logic.block().get()).m_49966_();
        if ((newState = (BlockState)newState.m_61124_((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(!offsetFromMaster.equals((Object)Vec3i.f_123288_)))).m_61138_((Property)IEProperties.MIRRORED)) {
            newState = (BlockState)newState.m_61124_((Property)IEProperties.MIRRORED, (Comparable)Boolean.valueOf(mirrored));
        }
        if (newState.m_61138_((Property)IEProperties.FACING_HORIZONTAL)) {
            newState = (BlockState)newState.m_61124_((Property)IEProperties.FACING_HORIZONTAL, (Comparable)clickDirection.m_122424_());
        }
        BlockState oldState = world.m_8055_(actualPos);
        world.m_7731_(actualPos, newState, 0);
        BlockEntity curr = world.m_7702_(actualPos);
        if (curr instanceof MultiblockBlockEntityDummy) {
            MultiblockBlockEntityDummy dummy = (MultiblockBlockEntityDummy)curr;
            dummy.getHelper().setPositionInMB(info.f_74675_());
        } else if (!(curr instanceof MultiblockBlockEntityMaster)) {
            IELogger.logger.error("Expected MB TE at {} during placement", (Object)actualPos);
        }
        LevelChunk chunk = world.m_46745_(actualPos);
        world.markAndNotifyBlock(actualPos, chunk, oldState, newState, 3, 512);
    }

    public ResourceLocation getBlockName() {
        return this.logic.id();
    }

    public Component getDisplayName() {
        return ((MultiblockPartBlock)this.logic.block().get()).m_49954_();
    }

    public Block getBlock() {
        return (Block)this.logic.block().get();
    }

    @Deprecated
    public Block getBaseBlock() {
        return this.getBlock();
    }

    public Vec3i getSize(@Nullable Level world) {
        return this.size;
    }

    @Nonnull
    public TemplateMultiblock.TemplateData getTemplate(@Nonnull Level world) {
        TemplateMultiblock.TemplateData result = super.getTemplate(world);
        Vec3i resultSize = result.template().m_163801_();
        Preconditions.checkState((boolean)resultSize.equals((Object)this.size), (String)"Wrong template size for multiblock %s, template size: %s", (Object)this.getTemplateLocation(), (Object)resultSize);
        return result;
    }

    protected void prepareBlockForDisassembly(Level world, BlockPos pos) {
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)be;
            multiblockBE.getHelper().markDisassembling();
        } else if (be != null) {
            IELogger.logger.error("Expected multiblock TE at {}, got {}", (Object)pos, (Object)be);
        }
    }

    @Override
    public int getDefaultBatchInput() {
        return 1;
    }

    @Override
    public int getDefaultBatchOutput() {
        return 1;
    }

    @Override
    public int getDefaultTime() {
        return 100;
    }

    @Override
    public int getDefaultEnergy() {
        return 100;
    }

    public ItemStack getFormationItem() {
        IGMBFormationItem stoneHammer = (IGMBFormationItem)StoneEnum.MCStone.getItem(ItemCategoryFlags.HAMMER);
        IGMBFormationItem bronzeHammer = (IGMBFormationItem)MetalEnum.Bronze.getItem(ItemCategoryFlags.HAMMER);
        IGMBFormationItem stainlessSteelHammer = (IGMBFormationItem)MetalEnum.StainlessSteel.getItem(ItemCategoryFlags.HAMMER);
        boolean canFormStone = stoneHammer.canFormMB(StoneEnum.MCStone, this);
        boolean canFormBronze = bronzeHammer.canFormMB(MetalEnum.Bronze, this);
        boolean canFormStainlessSteel = stainlessSteelHammer.canFormMB(MetalEnum.StainlessSteel, this);
        if (canFormStone) {
            return StoneEnum.MCStone.getStack(ItemCategoryFlags.HAMMER);
        }
        if (canFormBronze) {
            return MetalEnum.Bronze.getStack(ItemCategoryFlags.HAMMER);
        }
        if (canFormStainlessSteel) {
            return MetalEnum.StainlessSteel.getStack(ItemCategoryFlags.HAMMER);
        }
        return new ItemStack((ItemLike)IEItems.Tools.HAMMER);
    }
}

