/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic;

import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.api.energy.NullEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.interfaces.MBOverlayText;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import com.google.common.collect.ImmutableList;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGMultiblockState;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.ISkinnableMultiblockLogic;
import com.igteam.immersivegeology.common.block.multiblocks.shapes.AlternatorShape;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlternatorLogic
implements ISkinnableMultiblockLogic<State>,
MBOverlayText<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos REDSTONE_IN = new BlockPos(6, 1, 0);
    private static final List<BlockPos> ENERGY_OUTPUTS = IntStream.range(2, 5).mapToObj(i -> new BlockPos(5, i, 0)).toList();
    public static final BlockPos ROTATION_IN = new BlockPos(3, 3, 4);
    public static final BlockPos FORMATION_LOC = new BlockPos(3, 4, 4);
    private static final int MAX_ENERGY_OUTPUT = 32768;
    private static final float MAX_TURBINE_SPEED = 0.21f;

    public void tickClient(IMultiblockContext<State> ctx) {
        State state = (State)ctx.getState();
        state.render_rotation += state.rotation_speed;
        state.render_rotation %= 1.0f;
        if (state.render_rotation < 0.0f) {
            state.render_rotation += 1.0f;
        }
        if (state.request_sync) {
            state.request_sync = false;
            ctx.requestMasterBESync();
        }
    }

    public void tickServer(IMultiblockContext<State> ctx) {
        State state = (State)ctx.getState();
        state.rotation_speed = Mth.m_14179_((float)0.1f, (float)state.rotation_speed, (float)state.target_rotation);
        if (state.rotation_speed > 0.0f) {
            this.provideFlux(state);
        }
        if (state.target_rotation > 0.0f) {
            state.target_rotation = Mth.m_14179_((float)0.005f, (float)state.target_rotation, (float)0.0f);
            if (state.target_rotation < 0.001f) {
                state.target_rotation = 0.0f;
            }
        }
        if (state.request_sync) {
            state.request_sync = false;
            ctx.requestMasterBESync();
        }
        ctx.markDirtyAndSync();
    }

    public boolean provideFlux(State state) {
        int output;
        List presentOutputs = state.energyOutputs.stream().map(CapabilityReference::getNullable).filter(Objects::nonNull).collect(Collectors.toList());
        if (!presentOutputs.isEmpty() && EnergyHelper.distributeFlux(presentOutputs, (int)(output = Math.round(32768.0f * (state.rotation_speed / 0.16f))), (boolean)true) < output) {
            return EnergyHelper.distributeFlux(presentOutputs, (int)output, (boolean)false) < output;
        }
        return false;
    }

    public State createInitialState(IInitialMultiblockContext<State> capability) {
        return new State(capability);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return AlternatorShape.GETTER;
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        if (cap != ForgeCapabilities.FLUID_HANDLER && cap != IRotationAcceptor.CAPABILITY) {
            if (cap != ForgeCapabilities.ENERGY) {
                return LazyOptional.empty();
            }
            if (!(position.side() == null || position.side() == RelativeBlockFace.RIGHT && ENERGY_OUTPUTS.contains(position.posInMultiblock()))) {
                return LazyOptional.empty();
            }
            return ((State)ctx.getState()).energyView.cast(ctx);
        }
        if (cap == IRotationAcceptor.CAPABILITY && ROTATION_IN.equals((Object)position.posInMultiblock())) {
            return ((State)ctx.getState()).rotationCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    @Nullable
    public List<Component> getOverlayText(State state, Player player, boolean b) {
        if (state == null) {
            return List.of();
        }
        int rpm = Math.round(state.rotation_speed * 1200.0f);
        return List.of(Component.m_237115_((String)"immersivegeology.alternator.rpm").m_130946_(String.valueOf(rpm)));
    }

    public static class State
    implements IGMultiblockState {
        private final StoredCapability<IEnergyStorage> energyView;
        private final StoredCapability<IRotationAcceptor> rotationCap;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final List<CapabilityReference<IEnergyStorage>> energyOutputs;
        public float render_rotation = 0.0f;
        public float target_rotation = 0.0f;
        public float rotation_speed = 0.0f;
        private boolean request_sync = false;

        public State(IInitialMultiblockContext<State> ctx) {
            ImmutableList.Builder outputs = ImmutableList.builder();
            for (BlockPos pos : ENERGY_OUTPUTS) {
                outputs.add((Object)ctx.getCapabilityAt(ForgeCapabilities.ENERGY, pos, RelativeBlockFace.RIGHT));
            }
            this.energyOutputs = outputs.build();
            this.rotationCap = new StoredCapability((Object)new RotationAcceptor());
            this.energyView = new StoredCapability((Object)NullEnergyStorage.INSTANCE);
        }

        @Override
        public void invalidate(@NotNull IMultiblockContext<?> context) {
            this.energyView.get(context).invalidate();
            this.rotationCap.get(context).invalidate();
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.readSyncNBT(nbt);
            this.render_rotation = nbt.m_128457_("rotation");
        }

        public void writeSaveNBT(CompoundTag nbt) {
            this.writeSyncNBT(nbt);
            nbt.m_128350_("rotation", this.render_rotation);
        }

        public void writeSyncNBT(CompoundTag nbt) {
            nbt.m_128350_("target_rotation", this.target_rotation);
            nbt.m_128350_("rotation_speed", this.rotation_speed);
            nbt.m_128379_("request_sync", this.request_sync);
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.target_rotation = nbt.m_128457_("target_rotation");
            this.rotation_speed = nbt.m_128457_("rotation_speed");
            this.request_sync = nbt.m_128471_("request_sync");
        }

        public float getRenderRotation() {
            return this.render_rotation;
        }

        public void setTargetRotation(double rotation) {
            this.target_rotation = (float)rotation;
            this.request_sync = true;
        }

        private class RotationAcceptor
        implements IRotationAcceptor {
            private RotationAcceptor() {
            }

            public void inputRotation(double inputValue) {
                double normalizedRPT = this.convertToRPT(inputValue);
                State.this.setTargetRotation(Math.min(normalizedRPT, (double)0.21f));
            }

            private double convertToRPT(double raw) {
                if (raw >= 9.0) {
                    return raw / 0.75 / 2880.0;
                }
                if (raw >= 2.0) {
                    return raw / 1600.0;
                }
                return raw;
            }
        }
    }
}

