/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.NonMirrorableWithActiveBlock;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import com.igteam.immersivegeology.common.block.multiblocks.IGBloomeryMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGFurnaceHandler;
import com.igteam.immersivegeology.common.block.multiblocks.part.BloomeryPart;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.BloomeryFuel;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.BloomeryRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.shapes.BloomeryShape;
import com.igteam.immersivegeology.common.block.multiblocks.skins.IGBloomerySkins;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class BloomeryLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int NUM_SLOTS = 3;
    private static final Vec3 SMOKE_POSITION = new Vec3(1.0, 2.75, 1.0);

    public void tickClient(IMultiblockContext<State> context) {
        Boolean wasActive = (Boolean)context.getLevel().getBlockState(IGBloomeryMultiblock.INSTANCE.getMasterFromOriginOffset()).m_61143_(NonMirrorableWithActiveBlock.ACTIVE);
        if (context.getLevel().shouldTickModulo(2) && wasActive.booleanValue()) {
            this.spawnSmoke(context, new Vec3(1.0, 2.75, 1.0));
        }
    }

    private double particleXZSpeed() {
        return ApiUtils.RANDOM.nextDouble(-0.015625, 0.015625);
    }

    private void spawnSmoke(IMultiblockContext<State> context, Vec3 position) {
        Vec3 absoluteSmokePosition = context.getLevel().toAbsolute(position);
        context.getLevel().getRawLevel().m_7107_((ParticleOptions)ParticleTypes.f_123777_, absoluteSmokePosition.f_82479_, absoluteSmokePosition.f_82480_, absoluteSmokePosition.f_82481_, this.particleXZSpeed(), 0.0625, this.particleXZSpeed());
    }

    public void tickServer(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        IMultiblockLevel level = context.getLevel();
        Boolean wasActive = (Boolean)level.getBlockState(IGBloomeryMultiblock.INSTANCE.getMasterFromOriginOffset()).m_61143_((Property)IEProperties.ACTIVE);
        boolean active = state.furnace.tickServer(context, 0);
        if (active != wasActive) {
            IGBloomerySkins current_skin = (IGBloomerySkins)((Object)level.getBlockState(IGBloomeryMultiblock.INSTANCE.getMasterFromOriginOffset()).m_61143_(BloomeryPart.BLOOMERY));
            NonMirrorableWithActiveBlock.setActive((IMultiblockLevel)level, (TemplateMultiblock)IGBloomeryMultiblock.INSTANCE, (boolean)active);
            BloomeryPart.setSkin(level, IGBloomeryMultiblock.INSTANCE, current_skin);
        }
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }

    public State createInitialState(IInitialMultiblockContext<State> capability) {
        return new State(capability);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return BloomeryShape.GETTER;
    }

    public static class State
    implements IMultiblockState,
    IGFurnaceHandler.IFurnaceEnvironment<BloomeryRecipe> {
        private final SlotwiseItemHandler inventory;
        final IGFurnaceHandler<BloomeryRecipe> furnace;
        private final Supplier<BloomeryRecipe> cachedRecipe;

        public State(IInitialMultiblockContext<State> ctx) {
            Supplier getLevel = ctx.levelSupplier();
            this.inventory = new SlotwiseItemHandler(List.of(new SlotwiseItemHandler.IOConstraint(true, arg_0 -> State.lambda$new$0((Supplier)getLevel, arg_0)), new SlotwiseItemHandler.IOConstraint(true, arg_0 -> State.lambda$new$1((Supplier)getLevel, arg_0)), SlotwiseItemHandler.IOConstraint.OUTPUT, SlotwiseItemHandler.IOConstraint.OUTPUT), ctx.getMarkDirtyRunnable());
            this.furnace = new IGFurnaceHandler<BloomeryRecipe>(1, List.of(new IGFurnaceHandler.InputSlot<BloomeryRecipe>(r -> r.input, 0)), List.of(new IGFurnaceHandler.OutputSlot<BloomeryRecipe>(r -> r.result, 2)), r -> r.time, ctx.getMarkDirtyRunnable());
            this.cachedRecipe = CachedRecipe.cached(BloomeryRecipe::findRecipe, (Supplier)getLevel, () -> this.inventory.getStackInSlot(0));
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.furnace.readNBT((Tag)nbt.m_128469_("furnace"), 0);
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
            nbt.m_128365_("furnace", this.furnace.toNBT(0));
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
        }

        @Override
        public IItemHandlerModifiable getInventory(int furnaceIndex) {
            return this.inventory;
        }

        @Override
        @Nullable
        public BloomeryRecipe getRecipeForInput(int furnaceIndex) {
            return this.cachedRecipe.get();
        }

        @Override
        public int getBurnTimeOf(Level level, ItemStack fuel) {
            return BloomeryFuel.getBloomeryFuelTime(level, fuel);
        }

        public ContainerData getStateView() {
            return this.furnace.stateView;
        }

        private static /* synthetic */ boolean lambda$new$1(Supplier getLevel, ItemStack i) {
            return BloomeryFuel.isValidBloomeryFuel((Level)getLevel.get(), i);
        }

        private static /* synthetic */ boolean lambda$new$0(Supplier getLevel, ItemStack i) {
            return BloomeryRecipe.findRecipe((Level)getLevel.get(), i, null) != null;
        }
    }
}

