/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.interfaces.MBOverlayText;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGMultiblockState;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.CoreDrillRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.shapes.CoreDrillShape;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreDrillLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State>,
MBOverlayText<State> {
    public static final BlockPos REDSTONE_IN = new BlockPos(3, 1, 8);
    private static final int ENERGY_CAPACITY = 64000;
    private static final Set<CapabilityPosition> ENERGY_INPUTS = Set.of(new CapabilityPosition(4, 0, 8, RelativeBlockFace.BACK), new CapabilityPosition(4, 1, 8, RelativeBlockFace.BACK), new CapabilityPosition(4, 2, 8, RelativeBlockFace.BACK));
    private static final MultiblockFace FLUID_OUTPUT = new MultiblockFace(8, 0, 3, RelativeBlockFace.LEFT);
    private static final CapabilityPosition FLUID_OUTPUT_CAP = new CapabilityPosition(8, 0, 3, RelativeBlockFace.LEFT);
    private static final CapabilityPosition FLUID_INPUT_CAP = new CapabilityPosition(8, 0, 5, RelativeBlockFace.LEFT);
    public static final int TANK_VOLUME = 8000;
    public static final int ENERGY_CONSUMPTION_RATE = 4092;
    private static final float GEAR_RATIO = 65.0f;
    private static final float MAX_DRILL_SHAKE = 0.01f;
    private static final float DRILL_HEIGHT_INCREMENT = 0.03125f;
    private static final float MAX_DRILL_HEIGHT = -4.0f;
    private static final int SHAKE_PROBABILITY = 85;

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.getInventory(), drop);
    }

    public void tickClient(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        if (state.renderAsActive && state.spinDown && state.spinWait == 1) {
            Vec3 position = new Vec3(4.5, 0.0, 4.5);
            double xSpeed = ApiUtils.RANDOM.nextDouble(-0.25, 0.25);
            double zSpeed = ApiUtils.RANDOM.nextDouble(-0.25, 0.25);
            if (!state.drill_direction) {
                Vec3 absoluteSmokePosition = context.getLevel().toAbsolute(position);
                context.getLevel().getRawLevel().m_7106_((ParticleOptions)ParticleTypes.f_123759_, absoluteSmokePosition.f_82479_, absoluteSmokePosition.f_82480_, absoluteSmokePosition.f_82481_, xSpeed, 0.0625, zSpeed);
            }
            for (int i = 0; i < 4; ++i) {
                Vec3 exhaust = context.getLevel().toAbsolute(new Vec3(2.75, (double)(8.25f + state.drill_height - (float)i * 0.6f), 4.5));
                zSpeed = ApiUtils.RANDOM.nextDouble(-0.2, -0.015625);
                xSpeed = ApiUtils.RANDOM.nextDouble(-0.015625, 0.005625);
                context.getLevel().getRawLevel().m_7107_((ParticleOptions)ParticleTypes.f_123762_, exhaust.f_82479_, exhaust.f_82480_, exhaust.f_82481_, zSpeed, 0.0625, xSpeed);
            }
        }
        this.animateDrill(context);
    }

    private void animateDrill(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        Random rand = null;
        if (state.renderAsActive) {
            if (state.spinDown && state.spinWait == 1) {
                float gearAngle;
                rand = new Random();
                state.drill_angle = (state.drill_angle + state.drill_spin_rate) % 360.0f;
                float newDrillHeight = state.drill_height;
                if (rand.nextInt(100) > 85) {
                    newDrillHeight += rand.nextFloat() * 0.025f;
                }
                state.drill_height = newDrillHeight;
                state.gear_clockwise_angle = gearAngle = state.drill_height * 65.0f;
                state.gear_counter_clockwise_angle = -gearAngle;
                state.drill_shake = rand.nextInt(100) > 85 ? rand.nextFloat(0.0f, 0.01f) : 0.0f;
            } else if (state.spinWait - 1 > 0) {
                state.drill_angle = (state.drill_angle + state.drill_spin_rate) % 360.0f;
                rand = new Random();
                float shakeRange = (float)state.spinWait / (float)state.spinWaitReset * 0.0075f;
                state.drill_shake = rand.nextFloat(-shakeRange, shakeRange);
            }
        } else if (state.drill_spin_rate != 0.0f) {
            state.drill_angle = (state.drill_angle + state.drill_spin_rate) % 360.0f;
            if (state.drill_height < -0.03125f) {
                float gearAngle;
                state.gear_clockwise_angle = gearAngle = state.drill_height * 65.0f;
                state.gear_counter_clockwise_angle = -gearAngle;
            }
        }
    }

    private float adjustHeight(float current, float min, float max, float difference, State state) {
        boolean increase = state.drill_direction;
        if (increase) {
            if (current + difference < max) {
                return current + difference;
            }
            state.drill_direction = false;
        }
        if (current - difference > min) {
            return current - difference;
        }
        state.drill_direction = true;
        return current;
    }

    public void tickServer(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        boolean wasActive = state.renderAsActive;
        boolean bl = state.renderAsActive = !state.rsState.isEnabled(context) && state.getEnergy().getEnergyStored() > 4092;
        if (wasActive != state.renderAsActive) {
            context.requestMasterBESync();
        }
        if (state.output_tank.getFluidAmount() > 0) {
            this.drainOutputTank(state, context);
        }
        if (!state.rsState.isEnabled(context) && state.energy.getEnergyStored() > 4092 && state.energy.extractEnergy(4092, true) > 0) {
            FluidStack toFill;
            int amount;
            state.energy.extractEnergy(4092, false);
            CoreDrillRecipe recipe = CoreDrillRecipe.get(context.getLevel().getRawLevel(), state.acid_tank.getFluid());
            if (recipe != null && !state.drill_direction && state.spinDown && !state.acid_tank.drain(amount = recipe.getInput().getAmount(), IFluidHandler.FluidAction.SIMULATE).isEmpty() && state.output_tank.fill(toFill = new FluidStack(recipe.getOutput(), 1), IFluidHandler.FluidAction.SIMULATE) > 0) {
                state.acid_tank.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                state.output_tank.fill(toFill, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        Random rand = null;
        if (state.renderAsActive) {
            if (state.spinDown && state.spinWait == 1) {
                rand = new Random();
                float newDrillHeight = this.adjustHeight(state.drill_height, -4.0f, 0.0f, 0.03125f, state);
                if (rand.nextInt(100) > 85) {
                    newDrillHeight += rand.nextFloat() * 0.025f;
                }
                state.drill_height = newDrillHeight;
            } else if (state.spinWait - 1 > 0) {
                --state.spinWait;
                float spinProgress = (float)(state.spinWaitReset - state.spinWait) / (float)state.spinWaitReset;
                state.drill_spin_rate = 12.0f * spinProgress;
            } else {
                state.spinDown = true;
            }
        } else if (state.drill_spin_rate != 0.0f) {
            ++state.spinWait;
            state.drill_spin_rate = 24.0f * (1.0f - (float)state.spinWait / (float)state.spinWaitReset);
            state.drill_direction = true;
            if (state.drill_height < -0.03125f) {
                state.drill_height = this.adjustHeight(state.drill_height, -4.0f, 0.0f, 0.03125f, state);
            }
        }
        context.requestMasterBESync();
    }

    private void drainOutputTank(State state, IMultiblockContext<State> context) {
        int outSize = Math.min(1000, state.output_tank.getFluidAmount());
        CapabilityReference<IFluidHandler> outputRef = state.fluidOutput;
        FluidStack out = Utils.copyFluidStackWithAmount((FluidStack)state.output_tank.getFluid(), (int)outSize, (boolean)false);
        IFluidHandler output = (IFluidHandler)outputRef.getNullable();
        if (output == null) {
            return;
        }
        int accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE);
        if (accepted > 0) {
            int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.getAmount(), accepted), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
            state.output_tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
            context.markMasterDirty();
            context.requestMasterBESync();
        }
    }

    private void drainInputTank(State state, IMultiblockContext<State> context) {
        int outSize = Math.min(1000, state.acid_tank.getFluidAmount());
        CapabilityReference<IFluidHandler> outputRef = state.fluidOutput;
        FluidStack out = Utils.copyFluidStackWithAmount((FluidStack)state.acid_tank.getFluid(), (int)outSize, (boolean)false);
        IFluidHandler output = (IFluidHandler)outputRef.getNullable();
        if (output == null) {
            return;
        }
        int accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE);
        if (accepted > 0) {
            int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.getAmount(), accepted), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
            state.acid_tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
            context.markMasterDirty();
            context.requestMasterBESync();
        }
    }

    public State createInitialState(IInitialMultiblockContext<State> capability) {
        return new State(capability);
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.ENERGY && (position.side() == null || ENERGY_INPUTS.contains(position))) {
            return state.energyCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (FLUID_OUTPUT_CAP.equals((Object)position)) {
                return state.fOutputCap.cast(ctx);
            }
            if (FLUID_INPUT_CAP.equals((Object)position)) {
                return state.fInputCap.cast(ctx);
            }
        }
        return LazyOptional.empty();
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return CoreDrillShape.GETTER;
    }

    @Nullable
    public List<Component> getOverlayText(State state, Player player, boolean b) {
        if (Utils.isFluidRelatedItemStack((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND))) {
            return List.of(TextUtils.formatFluidStack((FluidStack)state.acid_tank.getFluid()), TextUtils.formatFluidStack((FluidStack)state.output_tank.getFluid()));
        }
        return null;
    }

    public static class State
    implements IGMultiblockState,
    ProcessContext.ProcessContextInWorld<CoreDrillRecipe> {
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(64000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final FluidTank acid_tank = new FluidTank(8000);
        public final FluidTank output_tank = new FluidTank(8000);
        private final MultiblockProcessor<CoreDrillRecipe, ProcessContext.ProcessContextInWorld<CoreDrillRecipe>> processor;
        private final CapabilityReference<IFluidHandler> fluidOutput;
        private final StoredCapability<IFluidHandler> fInputCap;
        private final StoredCapability<IFluidHandler> fOutputCap;
        private final StoredCapability<IEnergyStorage> energyCap;
        private float drill_angle;
        private float gear_clockwise_angle;
        private float gear_counter_clockwise_angle;
        private float drill_height;
        private boolean drill_direction = false;
        private boolean renderAsActive;
        private float drill_shake;
        private float drill_spin_rate;
        private boolean spinDown = false;
        private int spinWaitReset;
        private int spinWait = this.spinWaitReset = 260;

        public State(IInitialMultiblockContext<State> ctx) {
            this.fluidOutput = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, FLUID_OUTPUT.face().offsetRelative(FLUID_OUTPUT.posInMultiblock(), 1), FLUID_OUTPUT.face());
            this.processor = new MultiblockProcessor(2048, 0.0f, 1, ctx.getMarkDirtyRunnable(), (arg_0, arg_1) -> CoreDrillRecipe.RECIPES.getById(arg_0, arg_1));
            this.energyCap = new StoredCapability((Object)this.energy);
            Runnable changedAndSync = () -> {
                ctx.getSyncRunnable().run();
                ctx.getMarkDirtyRunnable().run();
            };
            this.fInputCap = new StoredCapability((Object)new ArrayFluidHandler((IFluidTank)this.acid_tank, true, true, changedAndSync));
            this.fOutputCap = new StoredCapability((Object)new ArrayFluidHandler((IFluidTank)this.output_tank, true, true, changedAndSync));
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("acid_tank", (Tag)this.acid_tank.writeToNBT(new CompoundTag()));
            nbt.m_128365_("output_tank", (Tag)this.output_tank.writeToNBT(new CompoundTag()));
            nbt.m_128365_("processor", this.processor.toNBT());
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.acid_tank.readFromNBT(nbt.m_128469_("acid_tank"));
            this.output_tank.readFromNBT(nbt.m_128469_("output_tank"));
            this.processor.fromNBT(nbt.m_128423_("processor"), MultiblockProcessInWorld::new);
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
            nbt.m_128379_("renderActive", this.renderAsActive);
            nbt.m_128379_("drillDirection", this.drill_direction);
            nbt.m_128379_("spinDown", this.spinDown);
            nbt.m_128350_("drillHeight", this.drill_height);
            nbt.m_128350_("drillSpinRate", this.drill_spin_rate);
            nbt.m_128405_("spinWaitReset", this.spinWaitReset);
            nbt.m_128405_("spinWait", this.spinWait);
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
            this.renderAsActive = nbt.m_128471_("renderActive");
            this.drill_direction = nbt.m_128471_("drillDirection");
            this.spinDown = nbt.m_128471_("spinDown");
            this.drill_height = nbt.m_128457_("drillHeight");
            this.drill_spin_rate = nbt.m_128457_("drillSpinRate");
            this.spinWaitReset = nbt.m_128451_("spinWaitReset");
            this.spinWait = nbt.m_128451_("spinWait");
        }

        public boolean shouldRenderActive() {
            return this.renderAsActive;
        }

        public float getDrillAngle() {
            return this.drill_angle;
        }

        public float getDrillSpeed() {
            return this.drill_spin_rate;
        }

        public float getDrillHeight() {
            return this.drill_height;
        }

        public float getGearClockwiseAngle() {
            return this.gear_clockwise_angle;
        }

        public float getGearCounterClockwiseAngle() {
            return this.gear_counter_clockwise_angle;
        }

        public float getDrillShake() {
            return this.drill_shake;
        }

        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public boolean getDrillDirection() {
            return this.drill_direction;
        }

        @Override
        public void invalidate(@NotNull IMultiblockContext<?> context) {
            this.energyCap.get(context).invalidate();
            this.fOutputCap.get(context).invalidate();
            this.fInputCap.get(context).invalidate();
        }
    }
}

