/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.Utils;
import com.igteam.immersivegeology.common.block.multiblocks.IGGeothermalExchangerMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.GeothermalHeatHelper;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGMultiblockState;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.LazyGetter;
import com.igteam.immersivegeology.common.block.multiblocks.part.GeothermalPart;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.GeothermalBiomeRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.GeothermalConversionRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.GeothermalExchangerRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.shapes.GeothermalExchangerShape;
import com.igteam.immersivegeology.core.lib.IGLib;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class GeothermalExchangerLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos REDSTONE_IN = new BlockPos(2, 5, 1);
    public static final int ENERGY_CAPACITY = 16000;
    private static final CapabilityPosition FLUID_INPUT_CAP = new CapabilityPosition(2, 3, 2, RelativeBlockFace.BACK);
    private static final CapabilityPosition FLUID_OUTPUT_CAP = new CapabilityPosition(2, 3, 0, RelativeBlockFace.FRONT);
    private static final CapabilityPosition ENERGY_INPUT = new CapabilityPosition(1, 4, 2, RelativeBlockFace.UP);
    public static final int TANK_VOLUME = 1000;
    private static final int GUI_SYNC_INTERVAL = 20;
    private static final int THERMAL_TRANSFER_INTERVAL = 3800;
    private static final int GRID_WIDTH = 5;
    private static final int GRID_DEPTH = 3;
    private static final float HEAT_LERP_FACTOR = 0.1f;

    public void tickClient(IMultiblockContext<State> context) {
    }

    public InteractionResult click(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        return super.click(ctx, posInMultiblock, player, hand, absoluteHit, isClient);
    }

    public static double convertToDisplayHeat(int input) {
        if (input < 300) {
            return -0.5 + (double)(input - 1) / 299.0 * 0.5;
        }
        if (input == 300) {
            return 0.0;
        }
        if (input < 1000) {
            return (double)(input - 300) / 700.0 * 0.25;
        }
        if (input == 1000) {
            return 0.25;
        }
        return 0.25 + (double)(input - 1000) / 2200.0 * 0.25;
    }

    public void tickServer(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        IMultiblockLevel multiblockLevel = context.getLevel();
        Level rawLevel = multiblockLevel.getRawLevel();
        Vec3i size = IGGeothermalExchangerMultiblock.INSTANCE.getSize(rawLevel);
        this.updateActiveState(state, context, size, multiblockLevel);
        if (state.isActive) {
            this.processActiveState(state, context, multiblockLevel, rawLevel);
        }
        List<TagKey<Biome>> biome_keys = state.biome_cache.get(multiblockLevel.getAbsoluteOrigin());
        for (TagKey<Biome> biome_key : biome_keys) {
            GeothermalBiomeRecipe recipe = GeothermalBiomeRecipe.findRecipe(rawLevel, biome_key);
            if (recipe == null) continue;
            state.minimum_temperature = recipe.getMinHeat();
            state.maximum_temperature = recipe.getMaxHeat();
        }
        ++state.ticks;
        if (state.ticks % 20 == 0) {
            this.syncBlockConversionData(state, IGGeothermalExchangerMultiblock.INSTANCE.getSize(rawLevel), multiblockLevel);
            context.markDirtyAndSync();
            if (state.ticks % 3800 == 0) {
                state.ticks = 0;
            }
        }
        this.updateDisplayHeat(state);
        if (state.output_tank.getFluidAmount() > 0) {
            this.drainOutputTank(state, context, state.fluidOutput);
        }
    }

    private void drainOutputTank(State state, IMultiblockContext<State> context, CapabilityReference<IFluidHandler> output_reference) {
        int outSize = Math.min(1000, state.output_tank.getFluidAmount());
        FluidStack out = Utils.copyFluidStackWithAmount((FluidStack)state.output_tank.getFluid(), (int)outSize, (boolean)false);
        IFluidHandler output = (IFluidHandler)output_reference.getNullable();
        if (output == null) {
            return;
        }
        int accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE);
        if (accepted > 0) {
            int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.getAmount(), accepted), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
            state.output_tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
            context.markMasterDirty();
            context.requestMasterBESync();
        }
    }

    private void updateActiveState(State state, IMultiblockContext<State> context, Vec3i size, IMultiblockLevel multiblockLevel) {
        boolean isActive;
        boolean wasActive = state.isActive;
        state.isActive = isActive = state.rsState.isEnabled(context);
        if (wasActive != isActive) {
            this.syncBlockConversionData(state, size, multiblockLevel);
        }
    }

    private void processActiveState(State state, IMultiblockContext<State> context, IMultiblockLevel multiblockLevel, Level rawLevel) {
        state.processor.tickServer((ProcessContext)state, context.getLevel(), state.rsState.isEnabled(context));
        boolean runningRecipe = state.processor.getQueueSize() > 0;
        this.tryRunRecipe(state, multiblockLevel);
        if (runningRecipe && state.output_tank.getSpace() > 0) {
            state.cooling_rate = Mth.m_14179_((float)0.1f, (float)state.cooling_rate, (float)((float)state.ticks / 3800.0f));
            GeothermalExchangerRecipe exchangerRecipe = state.cachedRecipe.get();
            if (exchangerRecipe != null) {
                int outputTemp = ((FluidStack)exchangerRecipe.fluidOutput.get()).getFluid().getFluidType().getTemperature();
                GeothermalConversionRecipe recipe = state.heatHelper.findCellWithHeat(exchangerRecipe.isCooling(), outputTemp);
                if (recipe != null) {
                    state.heat = Math.max(state.minimum_temperature, Math.min(recipe.blockHeat, state.maximum_temperature));
                } else {
                    int inputFluidTemp = exchangerRecipe.fluidIn.getRandomizedExampleStack(0).getFluid().getFluidType().getTemperature();
                    state.heat = (int)Mth.m_14179_((float)0.1f, (float)state.heat, (float)Math.max(state.minimum_temperature, Math.min(inputFluidTemp, state.maximum_temperature)));
                }
                if (this.shouldProcessConversion(state, multiblockLevel)) {
                    this.processGeothermalConversion(state, multiblockLevel);
                }
            }
        } else {
            state.heat = (int)Mth.m_14179_((float)0.1f, (float)state.heat, (float)state.minimum_temperature);
        }
    }

    private boolean shouldProcessConversion(State state, IMultiblockLevel multiblockLevel) {
        if (state.ticks % 3800 != 0) {
            return false;
        }
        state.heatHelper.setupRecipeData(multiblockLevel);
        Level rawLevel = multiblockLevel.getRawLevel();
        List queue = state.processor.getQueue();
        GeothermalExchangerRecipe cachedRecipe = state.cachedRecipe.get();
        if (cachedRecipe == null) {
            return false;
        }
        return !queue.isEmpty() && state.additionalCanProcessCheck((MultiblockProcess)queue.get(0), rawLevel);
    }

    private void processGeothermalConversion(State state, IMultiblockLevel multiblockLevel) {
        Level rawLevel = multiblockLevel.getRawLevel();
        RandomSource rand = rawLevel.f_46441_;
        GeothermalExchangerRecipe exchangerRecipe = state.cachedRecipe.get();
        GeothermalHeatHelper helper = state.heatHelper;
        BlockPos.MutableBlockPos localPos = new BlockPos.MutableBlockPos(0, state.currentY, 0);
        for (int attempts = 0; attempts < 66; ++attempts) {
            if (!this.processConversionGrid(state, helper, multiblockLevel, rawLevel, localPos, exchangerRecipe)) continue;
            this.syncBlockConversionData(state, IGGeothermalExchangerMultiblock.INSTANCE.getSize(rawLevel), multiblockLevel);
            return;
        }
        helper.clearMarks();
        state.currentY = 4;
    }

    private boolean processConversionGrid(State state, GeothermalHeatHelper helper, IMultiblockLevel multiblockLevel, Level rawLevel, BlockPos.MutableBlockPos localPos, GeothermalExchangerRecipe exchangerRecipe) {
        GeothermalConversionRecipe recipe = helper.getRandomCellPosition(state, localPos);
        if (recipe == null) {
            return false;
        }
        if (!exchangerRecipe.isCooling() && recipe.blockHeat >= ((FluidStack)exchangerRecipe.fluidOutput.get()).getRawFluid().getFluidType().getTemperature()) {
            return this.processConversionCell(helper, multiblockLevel, rawLevel, (BlockPos)localPos, exchangerRecipe);
        }
        if (exchangerRecipe.isCooling() && recipe.blockHeat <= ((FluidStack)exchangerRecipe.fluidOutput.get()).getRawFluid().getFluidType().getTemperature()) {
            return this.processConversionCell(helper, multiblockLevel, rawLevel, (BlockPos)localPos, exchangerRecipe);
        }
        return false;
    }

    private boolean processConversionCell(GeothermalHeatHelper helper, IMultiblockLevel multiblockLevel, Level rawLevel, BlockPos localPos, GeothermalExchangerRecipe exchangerRecipe) {
        GeothermalConversionRecipe conversionRecipe = helper.getRecipeFromCell(localPos);
        if (conversionRecipe == null) {
            return false;
        }
        if (exchangerRecipe.isCooling()) {
            Block upperTransition = conversionRecipe.upperTransition;
            if (upperTransition == null) {
                return false;
            }
            BlockPos absolutePos = multiblockLevel.toAbsolute(localPos).m_7495_();
            rawLevel.m_7731_(absolutePos, upperTransition.m_49966_(), 3);
            return true;
        }
        Block lowerTransition = conversionRecipe.lowerTransition;
        if (lowerTransition == null) {
            return false;
        }
        BlockPos absolutePos = multiblockLevel.toAbsolute(localPos).m_7495_();
        rawLevel.m_7731_(absolutePos, lowerTransition.m_49966_(), 3);
        return true;
    }

    private void updateDisplayHeat(State state) {
        state.display_heat = (float)Mth.m_14139_((double)0.1f, (double)state.display_heat, (double)GeothermalExchangerLogic.convertToDisplayHeat(state.heat));
    }

    private boolean tryRunRecipe(State state, IMultiblockLevel multiblockLevel) {
        Level rawLevel = multiblockLevel.getRawLevel();
        if (state.energy_storage.getEnergyStored() <= 0 || state.processor.getQueueSize() >= state.processor.getMaxQueueSize()) {
            return false;
        }
        FluidStack input = state.water_tank.getFluid();
        if (input.isEmpty()) {
            return false;
        }
        GeothermalExchangerRecipe recipe = GeothermalExchangerRecipe.findRecipe(rawLevel, input);
        if (recipe == null) {
            return false;
        }
        MultiblockProcessInMachine process = new MultiblockProcessInMachine((MultiblockRecipe)recipe, new int[0]);
        if (input.isEmpty()) {
            process.setInputTanks(new int[]{1});
        }
        int drainSimulation = state.water_tank.drain(recipe.fluidIn.getAmount(), IFluidHandler.FluidAction.SIMULATE).getAmount();
        int drainAmount = recipe.fluidIn.getAmount();
        if (state.processor.addProcessToQueue((MultiblockProcess)process, rawLevel, true) && drainSimulation == drainAmount) {
            state.processor.addProcessToQueue((MultiblockProcess)process, rawLevel, false);
            state.water_tank.drain(recipe.fluidIn.getAmount(), IFluidHandler.FluidAction.EXECUTE).getAmount();
            state.heatHelper.setupRecipeData(multiblockLevel);
            state.currentY = 4;
            return true;
        }
        return false;
    }

    private void syncBlockConversionData(State state, Vec3i size, IMultiblockLevel multiblockLevel) {
        int structureHeight = size.m_123342_() - 1;
        int structureLength = size.m_123341_();
        int structureWidth = size.m_123343_();
        HashSet<Block> blockSet = new HashSet<Block>();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        Level rawLevel = multiblockLevel.getRawLevel();
        int index = 0;
        for (int h = -1; h < structureHeight; ++h) {
            for (int l = 0; l < structureLength; ++l) {
                for (int w = 0; w < structureWidth; ++w) {
                    boolean isSource;
                    cursor.m_122178_(l, h, w);
                    BlockState relativeState = multiblockLevel.getBlockState((BlockPos)cursor);
                    FluidState fluidState = relativeState.m_60819_();
                    Block block = relativeState.m_60734_();
                    boolean isFluid = !fluidState.m_76178_();
                    boolean bl = isSource = isFluid && fluidState.m_76170_();
                    if (index >= 66 || block instanceof GeothermalPart) continue;
                    blockSet.add(block);
                    GeothermalConversionRecipe recipe = GeothermalConversionRecipe.findRecipe(rawLevel, block);
                    int heatBlockIndex = -1;
                    if (recipe != null && (isSource || !isFluid)) {
                        List recipeList = GeothermalConversionRecipe.RECIPES.getRecipes(rawLevel).stream().toList();
                        heatBlockIndex = recipeList.indexOf((Object)recipe);
                    }
                    state.setHeatStateAtIndex(index, heatBlockIndex);
                    ++index;
                }
            }
        }
    }

    public State createInitialState(IInitialMultiblockContext<State> capability) {
        return new State(capability);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return GeothermalExchangerShape.GETTER;
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.ENERGY && (position.side() == null || ENERGY_INPUT.equals((Object)position))) {
            return state.energyCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (FLUID_INPUT_CAP.equals((Object)position)) {
                return state.fInputCap.cast(ctx);
            }
            if (FLUID_OUTPUT_CAP.equals((Object)position)) {
                return state.fOutputCap.cast(ctx);
            }
        }
        return LazyOptional.empty();
    }

    public static class State
    implements IGMultiblockState,
    ProcessContext.ProcessContextInMachine<GeothermalExchangerRecipe> {
        private final MultiblockProcessor<GeothermalExchangerRecipe, ProcessContext.ProcessContextInMachine<GeothermalExchangerRecipe>> processor;
        private final FluidTank water_tank = new FluidTank(1000);
        private final FluidTank output_tank = new FluidTank(1000);
        private final AveragingEnergyStorage energy_storage = new AveragingEnergyStorage(16000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private byte[] heating_states = new byte[66];
        private boolean isActive = false;
        private float cooling_rate = 0.0f;
        private float display_heat = 0.0f;
        private int heat = 300;
        private int ticks;
        public int currentY = 4;
        private final StoredCapability<IFluidHandler> fInputCap;
        private final StoredCapability<IFluidHandler> fOutputCap;
        private final CapabilityReference<IFluidHandler> fluidOutput;
        private final StoredCapability<IEnergyStorage> energyCap = new StoredCapability((Object)this.energy_storage);
        private final Supplier<GeothermalExchangerRecipe> cachedRecipe;
        private final LazyGetter<BlockPos, List<TagKey<Biome>>> biome_cache;
        private int minimum_temperature = 1;
        private int maximum_temperature = 3200;
        private final MultiblockProcessor.InMachineProcessor<GeothermalExchangerRecipe> dummy;
        private final GeothermalHeatHelper heatHelper;

        public State(IInitialMultiblockContext<State> context) {
            Runnable changedAndSync = () -> {
                context.getSyncRunnable().run();
                context.getMarkDirtyRunnable().run();
            };
            this.fInputCap = new StoredCapability((Object)new ArrayFluidHandler((IFluidTank)this.water_tank, true, true, changedAndSync));
            this.fOutputCap = new StoredCapability((Object)new ArrayFluidHandler((IFluidTank)this.output_tank, true, false, changedAndSync));
            Supplier getLevel = context.levelSupplier();
            this.biome_cache = new LazyGetter<BlockPos, List>(arg_0 -> State.lambda$new$1((Supplier)getLevel, arg_0));
            this.heatHelper = new GeothermalHeatHelper(getLevel);
            this.cachedRecipe = CachedRecipe.cached(GeothermalExchangerRecipe::findRecipe, (Supplier)getLevel, () -> ((FluidTank)this.water_tank).getFluid());
            this.processor = new MultiblockProcessor(1, 0.0f, 1, context.getMarkDirtyRunnable(), (arg_0, arg_1) -> GeothermalExchangerRecipe.RECIPES.getById(arg_0, arg_1));
            assert (FLUID_OUTPUT_CAP.side() != null);
            this.fluidOutput = context.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, new MultiblockFace(FLUID_OUTPUT_CAP.side().getOpposite(), FLUID_OUTPUT_CAP.posInMultiblock().m_122012_()));
            this.dummy = new MultiblockProcessor.InMachineProcessor(1, 0.0f, 1, context.getMarkDirtyRunnable(), (arg_0, arg_1) -> GeothermalExchangerRecipe.RECIPES.getById(arg_0, arg_1));
        }

        public void clearProcessor() {
            this.processor.fromNBT(this.dummy.toNBT(), MultiblockProcessInMachine::new);
        }

        public boolean additionalCanProcessCheck(MultiblockProcess<GeothermalExchangerRecipe, ?> process, Level level) {
            GeothermalExchangerRecipe recipe = (GeothermalExchangerRecipe)process.getRecipe(level);
            if (this.cachedRecipe != null && this.cachedRecipe.get() != null && !((Object)((Object)this.cachedRecipe.get())).equals((Object)recipe)) {
                this.clearProcessor();
            }
            if (recipe == null) {
                return false;
            }
            int outputTemp = ((FluidStack)recipe.fluidOutput.get()).getFluid().getFluidType().getTemperature();
            boolean isGoodTemperature = recipe.isCooling() ? this.heat <= outputTemp : this.heat >= outputTemp;
            return (this.output_tank.getFluid().isFluidEqual((FluidStack)recipe.fluidOutput.get()) || this.output_tank.isEmpty()) && this.output_tank.getSpace() >= ((FluidStack)recipe.fluidOutput.get()).getAmount() && isGoodTemperature;
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
            this.heating_states = nbt.m_128463_("heating_states");
            this.currentY = nbt.m_128451_("current_y");
            this.ticks = nbt.m_128451_("internal_ticks");
            this.minimum_temperature = nbt.m_128451_("min_heat");
            this.maximum_temperature = nbt.m_128451_("max_heat");
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
            nbt.m_128382_("heating_states", this.heating_states);
            nbt.m_128405_("current_y", this.currentY);
            nbt.m_128405_("internal_ticks", this.ticks);
            nbt.m_128405_("min_heat", this.minimum_temperature);
            nbt.m_128405_("max_heat", this.maximum_temperature);
        }

        public FluidTank[] getInternalTanks() {
            return new FluidTank[]{this.water_tank, this.output_tank};
        }

        public int[] getOutputTanks() {
            return new int[]{1};
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.isActive = nbt.m_128471_("is_active");
            this.heat = nbt.m_128451_("heat");
            this.display_heat = nbt.m_128457_("display_heat");
            this.cooling_rate = nbt.m_128457_("cooling");
            this.water_tank.readFromNBT(nbt.m_128469_("water_tank"));
            this.output_tank.readFromNBT(nbt.m_128469_("steam_tank"));
            this.processor.fromNBT(nbt.m_128423_("processor"), MultiblockProcessInMachine::new);
            this.heatHelper.fromNBT(nbt);
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128379_("is_active", this.isActive);
            nbt.m_128405_("heat", this.heat);
            nbt.m_128350_("display_heat", this.display_heat);
            nbt.m_128350_("cooling", this.cooling_rate);
            nbt.m_128365_("water_tank", (Tag)this.water_tank.writeToNBT(new CompoundTag()));
            nbt.m_128365_("steam_tank", (Tag)this.output_tank.writeToNBT(new CompoundTag()));
            nbt.m_128365_("processor", this.processor.toNBT());
            nbt.m_128365_("helper", this.heatHelper.toNBT());
        }

        public void onProcessFinish(MultiblockProcess<GeothermalExchangerRecipe, ?> process, Level level) {
            try {
                GeothermalExchangerRecipe recipe = (GeothermalExchangerRecipe)process.getRecipe(level);
                if (recipe != null) {
                    this.output_tank.fill((FluidStack)recipe.fluidOutput.get(), IFluidHandler.FluidAction.EXECUTE);
                }
            }
            catch (Exception error) {
                IGLib.IG_LOGGER.error("Error: {}", (Object)error.getMessage());
            }
        }

        public int getCurrentHeat() {
            return this.heat;
        }

        public float getCoolingRate() {
            return this.cooling_rate;
        }

        public AveragingEnergyStorage getEnergy() {
            return this.energy_storage;
        }

        public void setHeatStateAtIndex(int index, int value) {
            this.heating_states[index] = (byte)value;
        }

        public byte[] getHeatingStates() {
            return this.heating_states;
        }

        public void setHeat(int machineHeat) {
            this.heat = machineHeat;
        }

        public float getDisplayHeat() {
            return this.display_heat;
        }

        @Override
        public void invalidate(@Nonnull IMultiblockContext<?> ctx) {
            this.fInputCap.get(ctx).invalidate();
            this.fOutputCap.get(ctx).invalidate();
            this.energyCap.get(ctx).invalidate();
        }

        private static /* synthetic */ List lambda$new$1(Supplier getLevel, BlockPos b) {
            return ((Level)getLevel.get()).m_204166_(b).getTagKeys().toList();
        }
    }
}

