/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.interfaces.MBOverlayText;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGMultiblockState;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.ISkinnableMultiblockLogic;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.PelletizerRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.shapes.PelletizerShape;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PelletizerLogic
implements ISkinnableMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State>,
MBOverlayText<State> {
    public static final BlockPos REDSTONE_IN = new BlockPos(2, 0, 0);
    public static final int ENERGY_CAPACITY = 12000;
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(1, 0, 4, RelativeBlockFace.FRONT);
    private static final Set<CapabilityPosition> ENERGY_INPUTS = Set.of(new CapabilityPosition(0, 1, 3, RelativeBlockFace.UP));
    public static final int TANK_VOLUME = 4000;
    private static final CapabilityPosition FLUID_INPUT_CAP = new CapabilityPosition(1, 0, 0, RelativeBlockFace.FRONT);
    private static final CapabilityPosition ITEM_OUTPUT_CAP = CapabilityPosition.opposing((MultiblockFace)OUTPUT_POS);
    public static final int ENERGY_CONSUMPTION_RATE = 20;
    private static final Random rand = new Random();
    private static Fluid bindingAgent = ChemicalEnum.BindingAgent.getFluid(BlockCategoryFlags.FLUID);

    public void tickClient(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        float rot = state.rotation;
        if (state.shouldRenderActive()) {
            state.rotation = (float)(((double)rot - 3.5) % 360.0);
            Level level = context.getLevel().getRawLevel();
            Vec3 absoluteSmokePosition = context.getLevel().toAbsolute(new Vec3(1.5, 1.5, 2.125));
            float red = 0.8235f;
            float green = 0.7059f;
            float blue = 0.549f;
            float scale = rand.nextFloat(0.25f, 1.25f);
            DustParticleOptions dust = new DustParticleOptions(new Vector3f(red, green, blue), scale);
            level.m_7106_((ParticleOptions)dust, absoluteSmokePosition.f_82479_ + (double)rand.nextFloat(-0.5f, 0.5f), absoluteSmokePosition.f_82480_ + (double)rand.nextFloat(-0.125f, 0.125f), absoluteSmokePosition.f_82481_ + (double)rand.nextFloat(-0.5f, 0.5f), 0.0, 0.1, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123769_, absoluteSmokePosition.f_82479_, absoluteSmokePosition.f_82480_ + 0.5, absoluteSmokePosition.f_82481_ - 0.5, 0.0, 0.1, 0.0);
        }
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.getInventory(), drop);
    }

    public void tickServer(IMultiblockContext<State> context) {
        ItemStack inputStack;
        State state = (State)context.getState();
        boolean isEnabled = state.rsState.isEnabled(context);
        boolean wasActive = state.renderAsActive;
        Level level = context.getLevel().getRawLevel();
        boolean bl = state.renderAsActive = isEnabled && !state.tank.isEmpty() && state.processor.tickServer((ProcessContext)state, context.getLevel(), state.rsState.isEnabled(context));
        if (wasActive != state.renderAsActive) {
            context.requestMasterBESync();
        }
        if (!(inputStack = state.inventory.getStackInSlot(0)).m_41619_() && (bindingAgent = ChemicalEnum.BindingAgent.getFluid(BlockCategoryFlags.FLUID)).m_6212_(state.tank.getFluid().getFluid())) {
            PelletizerRecipe recipe = PelletizerRecipe.findRecipe(level, inputStack);
            if (recipe == null) {
                return;
            }
            MultiblockProcessInWorld process = new MultiblockProcessInWorld((MultiblockRecipe)recipe, inputStack);
            if (state.processor.addProcessToQueue((MultiblockProcess)process, level, true)) {
                state.processor.addProcessToQueue((MultiblockProcess)process, level, false);
                inputStack.m_41774_(recipe.itemIn.getCount());
            }
            return;
        }
        if (state.processor.getQueueSize() > 0 && !state.tank.isEmpty() && isEnabled) {
            state.tank.drain(2, IFluidHandler.FluidAction.EXECUTE);
            context.requestMasterBESync();
        }
    }

    public State createInitialState(IInitialMultiblockContext<State> capability) {
        return new State(capability);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return PelletizerShape.GETTER;
    }

    public void onEntityCollision(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Entity collided) {
        if (collided.m_9236_().f_46443_) {
            return;
        }
        State state = (State)ctx.getState();
        IMultiblockLevel level = ctx.getLevel();
        AABB internalBB = new AABB(0.5, 0.0, 0.5, 2.5, 3.0, 2.5);
        AABB pelletizerHopper = level.toAbsolute(internalBB);
        if (collided instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)collided;
            if (collided.m_20191_().m_82381_(pelletizerHopper)) {
                ItemStack stack = itemEntity.m_32055_();
                if (stack.m_41619_()) {
                    return;
                }
                if (PelletizerLogic.insertItemToInventory(stack = stack.m_41777_(), state, level.getRawLevel(), true)) {
                    if (PelletizerLogic.insertItemToInventory(stack, state, level.getRawLevel(), false)) {
                        ctx.markDirtyAndSync();
                    }
                    if (stack.m_41613_() <= 0) {
                        itemEntity.m_146870_();
                    } else {
                        stack.m_41774_(1);
                        itemEntity.m_32045_(stack);
                    }
                }
            }
        }
    }

    private static boolean isInInput(BlockPos posInMultiblock, boolean allowMiddleLayer) {
        if (!(posInMultiblock.m_123342_() == 2 || allowMiddleLayer && posInMultiblock.m_123342_() == 1)) {
            return false;
        }
        return posInMultiblock.m_123341_() > 0 && posInMultiblock.m_123341_() < 4;
    }

    private static boolean insertItemToInventory(ItemStack stack, State state, Level level, boolean simulate) {
        if (PelletizerRecipe.findRecipe(level, stack) == null) {
            return false;
        }
        ItemStack remaining = ((IItemHandler)state.insertionHandler.getValue()).insertItem(0, new ItemStack((ItemLike)stack.m_41720_()), simulate);
        return remaining.m_41619_();
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.ENERGY && (position.side() == null || ENERGY_INPUTS.contains(position))) {
            return state.energyCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && FLUID_INPUT_CAP.equals((Object)position)) {
            return state.fInputCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    @Nullable
    public List<Component> getOverlayText(State state, Player player, boolean b) {
        if (state == null) {
            return null;
        }
        if (!state.tank.getFluid().getFluid().equals(ChemicalEnum.BindingAgent.getFluid(BlockCategoryFlags.FLUID))) {
            ItemStack stack = state.inventory.getStackInSlot(0);
            MutableComponent component = stack.m_41619_() ? Component.m_237119_() : Component.m_237113_((String)(stack.m_41786_().getString() + "x" + stack.m_41613_()));
            return List.of(Component.m_237113_((String)"No Binding Agent Available").m_130940_(ChatFormatting.RED), component);
        }
        if (Utils.isFluidRelatedItemStack((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND))) {
            return List.of(TextUtils.formatFluidStack((FluidStack)state.tank.getFluid()));
        }
        return null;
    }

    public static class State
    implements IGMultiblockState,
    ProcessContext.ProcessContextInWorld<PelletizerRecipe> {
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(12000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final FluidTank tank = new FluidTank(4000);
        private final StoredCapability<IFluidHandler> fInputCap;
        private final StoredCapability<IEnergyStorage> energyCap;
        private final StoredCapability<IItemHandler> insertionHandler;
        public final SlotwiseItemHandler inventory;
        private final DroppingMultiblockOutput output;
        private final MultiblockProcessor<PelletizerRecipe, ProcessContext.ProcessContextInWorld<PelletizerRecipe>> processor;
        private float rotation;
        private boolean renderAsActive;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public State(IInitialMultiblockContext<State> ctx) {
            @Nullable Supplier levelGetter = ctx.levelSupplier();
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            Runnable sync = ctx.getSyncRunnable();
            Runnable changedAndSync = () -> {
                markDirty.run();
                sync.run();
            };
            this.inventory = new SlotwiseItemHandler(List.of(new SlotwiseItemHandler.IOConstraint(true, arg_0 -> State.lambda$new$1((Supplier)levelGetter, arg_0)), SlotwiseItemHandler.IOConstraint.OUTPUT), markDirty);
            this.energyCap = new StoredCapability((Object)this.energy);
            this.output = new DroppingMultiblockOutput(OUTPUT_POS, ctx);
            this.processor = new MultiblockProcessor(64, 0.0f, 8, ctx.getMarkDirtyRunnable(), (arg_0, arg_1) -> PelletizerRecipe.RECIPES.getById(arg_0, arg_1));
            this.insertionHandler = new StoredCapability((Object)this.inventory);
            this.rotation = 0.0f;
            this.fInputCap = new StoredCapability((Object)new ArrayFluidHandler((IFluidTank)this.tank, true, true, changedAndSync));
        }

        public SlotwiseItemHandler getInventory() {
            return this.inventory;
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.processor.fromNBT(nbt.m_128423_("processor"), MultiblockProcessInWorld::new);
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }

        public void doProcessOutput(ItemStack result, IMultiblockLevel level) {
            this.output.insertOrDrop(result, level);
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("processor", this.processor.toNBT());
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
            nbt.m_128379_("renderActive", this.renderAsActive);
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
            this.renderAsActive = nbt.m_128471_("renderActive");
        }

        public float getRotation() {
            return this.rotation;
        }

        public boolean shouldRenderActive() {
            return this.renderAsActive;
        }

        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public List<MultiblockProcess<PelletizerRecipe, ProcessContext.ProcessContextInWorld<PelletizerRecipe>>> getProcessQueue() {
            return this.processor.getQueue();
        }

        @Override
        public void invalidate(@NotNull IMultiblockContext<?> ctx) {
            this.energyCap.get(ctx).invalidate();
            this.fInputCap.get(ctx).invalidate();
            this.insertionHandler.get(ctx).invalidate();
        }

        private static /* synthetic */ boolean lambda$new$1(Supplier levelGetter, ItemStack i) {
            return PelletizerRecipe.findRecipe((Level)levelGetter.get(), i) != null;
        }
    }
}

