/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic.helper;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import com.igteam.immersivegeology.common.block.multiblocks.logic.GeothermalExchangerLogic;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.GeothermalConversionRecipe;
import com.igteam.immersivegeology.core.lib.IGLib;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class GeothermalHeatHelper {
    private static final int LAYER_COUNT = 5;
    private static final int GRID_WIDTH = 5;
    private static final int GRID_LENGTH = 3;
    private static final int EMPTY_VALUE = 0;
    private final boolean[][][] markedCells;
    private byte[][][] data = new byte[5][5][3];
    private final Supplier<Level> level;
    private List<GeothermalConversionRecipe> cachedRecipes;
    private final Random random;

    public GeothermalHeatHelper(Supplier<Level> level) {
        this.markedCells = new boolean[5][5][3];
        this.level = level;
        this.random = new Random();
        this.clear();
        this.clearMarks();
    }

    private void ensureRecipesLoaded() {
        Level currentLevel;
        if (this.cachedRecipes == null && (currentLevel = this.level.get()) != null) {
            this.cachedRecipes = new ArrayList<GeothermalConversionRecipe>(GeothermalConversionRecipe.RECIPES.getRecipes(currentLevel));
        }
    }

    public List<GeothermalConversionRecipe> getRecipes() {
        this.ensureRecipesLoaded();
        return this.cachedRecipes != null ? this.cachedRecipes : Collections.emptyList();
    }

    public void clear() {
        for (int layer = 0; layer < 5; ++layer) {
            for (int x = 0; x < 5; ++x) {
                for (int y = 0; y < 3; ++y) {
                    this.data[layer][x][y] = 0;
                }
            }
        }
    }

    public void clearMarks() {
        for (int layer = 0; layer < 5; ++layer) {
            for (int x = 0; x < 5; ++x) {
                for (int y = 0; y < 3; ++y) {
                    this.markedCells[layer][x][y] = false;
                }
            }
        }
    }

    public void clearLayer(int layer) {
        if (layer < 0 || layer >= 5) {
            return;
        }
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 3; ++y) {
                this.data[layer][x][y] = 0;
            }
        }
    }

    public byte[] getLayerCopy(int layer) {
        if (layer < 0 || layer >= 5) {
            return null;
        }
        byte[] copy = new byte[15];
        int index = 0;
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 3; ++y) {
                copy[index++] = this.data[layer][x][y];
            }
        }
        return copy;
    }

    public byte accessDataAtLayer(int layer, int x, int z) {
        if (layer < 0 || layer >= 5 || x < 0 || x >= 5 || z < 0 || z >= 3) {
            return 0;
        }
        return this.data[layer][x][z];
    }

    public void setDataAtLayer(int layer, int x, int z, byte value) {
        if (layer < 0 || layer >= 5 || x < 0 || x >= 5 || z < 0 || z >= 3) {
            return;
        }
        this.data[layer][x][z] = value;
    }

    public byte getFastPseudoRandomCell(int layer, long seed) {
        if (layer < 0 || layer >= 5) {
            return 0;
        }
        long hash = seed * 31L + (long)layer;
        int x = (int)((hash >>> 16) % 3L);
        int y = (int)((hash >>> 8) % 5L);
        return this.accessDataAtLayer(layer, Math.abs(x), Math.abs(y));
    }

    public byte getRandomNonEmptyCellCoords(int layer, int[] outCoords) {
        if (layer < 0 || layer >= 5 || outCoords.length < 2) {
            return -1;
        }
        int availableCount = 0;
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 3; ++z) {
                if (this.accessDataAtLayer(layer, x, z) == 0 || this.markedCells[layer][x][z]) continue;
                ++availableCount;
            }
        }
        if (availableCount == 0) {
            return -1;
        }
        int targetIndex = this.random.nextInt(availableCount);
        int currentIndex = 0;
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 3; ++z) {
                byte value = this.accessDataAtLayer(layer, x, z);
                if (value == 0 || this.markedCells[layer][x][z]) continue;
                if (currentIndex == targetIndex) {
                    this.markedCells[layer][x][z] = true;
                    outCoords[0] = x;
                    outCoords[1] = z;
                    return value;
                }
                ++currentIndex;
            }
        }
        return -1;
    }

    @Nullable
    public GeothermalConversionRecipe getRandomCellPosition(GeothermalExchangerLogic.State state, BlockPos.MutableBlockPos localPos) {
        int[] xz = new int[]{0, 0};
        int id = this.getRandomNonEmptyCellCoords(localPos.m_123342_(), xz);
        if (id == -1) {
            --state.currentY;
            localPos.m_142448_(state.currentY);
        }
        localPos.m_142451_(xz[0]);
        localPos.m_142443_(xz[1]);
        return --id < 0 ? null : this.getRecipes().get(id);
    }

    @Nullable
    public GeothermalConversionRecipe getRecipeFromCell(BlockPos localPosition) {
        return this.getRecipeFromCell(localPosition.m_123342_(), localPosition.m_123341_(), localPosition.m_123343_());
    }

    @Nullable
    public GeothermalConversionRecipe getRecipeFromCell(int layer, int x, int z) {
        int id = this.accessDataAtLayer(layer, x, z) - 1;
        return id < 0 ? null : this.getRecipes().get(id);
    }

    public GeothermalConversionRecipe updateRecipeCell(IMultiblockLevel multiblockLevel, BlockPos pos) {
        return this.updateRecipeCell(multiblockLevel, pos.m_123342_(), pos.m_123341_(), pos.m_123343_());
    }

    public GeothermalConversionRecipe updateRecipeCell(IMultiblockLevel multiblockLevel, int layer, int x, int z) {
        Level rawLevel = multiblockLevel.getRawLevel();
        BlockPos.MutableBlockPos localPos = new BlockPos.MutableBlockPos(x, layer, z);
        BlockPos worldPos = multiblockLevel.toAbsolute((BlockPos)localPos);
        BlockState block = rawLevel.m_8055_(worldPos);
        GeothermalConversionRecipe recipe = GeothermalConversionRecipe.findRecipe(rawLevel, block.m_60734_());
        int recipeIndex = 1 + this.getRecipes().indexOf((Object)recipe);
        if (recipeIndex > 255) {
            IGLib.IG_LOGGER.error("Could not set Recipe Marker Correctly, recipe ID exceeds 255 (Undefined Behaviour is likely to occur)");
        }
        this.setDataAtLayer(layer, x, z, (byte)recipeIndex);
        return recipe;
    }

    public void setupRecipeData(IMultiblockLevel multiblockLevel) {
        Level rawLevel = multiblockLevel.getRawLevel();
        BlockPos.MutableBlockPos localPos = new BlockPos.MutableBlockPos(0, 0, 0);
        for (int layer = 0; layer < 5; ++layer) {
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 3; ++z) {
                    localPos.m_122178_(x, layer, z);
                    BlockState block = rawLevel.m_8055_(multiblockLevel.toAbsolute((BlockPos)localPos).m_7495_());
                    GeothermalConversionRecipe recipe = this.findRecipe(block.m_60734_());
                    int recipeIndex = 1 + this.getRecipes().indexOf((Object)recipe);
                    this.data[layer][x][z] = (byte)recipeIndex;
                }
            }
        }
    }

    public GeothermalConversionRecipe findRecipe(Block block) {
        for (GeothermalConversionRecipe recipe : this.getRecipes()) {
            if (!((Block)recipe.transitionBlock.get()).equals(block)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public GeothermalConversionRecipe findCellWithHeat(boolean cooling, int outputTemp) {
        boolean temperature = true;
        for (int layer = 0; layer < 5; ++layer) {
            for (int x = 0; x < 5; ++x) {
                for (int y = 0; y < 3; ++y) {
                    GeothermalConversionRecipe returnRecipe;
                    int id = this.data[layer][x][y] - 1;
                    if (id < 0 || (returnRecipe = this.getRecipes().get(id)) == null) continue;
                    int blockHeat = returnRecipe.blockHeat;
                    if (cooling && blockHeat <= outputTemp) {
                        return returnRecipe;
                    }
                    if (cooling || blockHeat < outputTemp) continue;
                    return returnRecipe;
                }
            }
        }
        return null;
    }

    public void fromNBT(CompoundTag tag) {
        CompoundTag nbt = tag.m_128469_("helper");
        byte[] flatData = nbt.m_128463_("data");
        this.data = GeothermalHeatHelper.reconstruct3DArray(flatData, 5, 5, 3);
        this.clearMarks();
        this.cachedRecipes = null;
    }

    public Tag toNBT() {
        CompoundTag tag_data = new CompoundTag();
        byte[] flatData = GeothermalHeatHelper.flatten3DArray(this.data);
        tag_data.m_128382_("data", flatData);
        return tag_data;
    }

    public static byte[] flatten3DArray(byte[][][] array3D) {
        if (array3D == null || array3D.length == 0) {
            return new byte[0];
        }
        int dim1 = array3D.length;
        int dim2 = array3D[0].length;
        int dim3 = array3D[0][0].length;
        int totalDataSize = dim1 * dim2 * dim3;
        byte[] result = new byte[totalDataSize];
        int index = 0;
        for (int i = 0; i < dim1; ++i) {
            for (int j = 0; j < dim2; ++j) {
                for (int k = 0; k < dim3; ++k) {
                    result[index++] = array3D[i][j][k];
                }
            }
        }
        return result;
    }

    public static byte[][][] reconstruct3DArray(byte[] flatArray, int dim1, int dim2, int dim3) {
        if (flatArray == null || dim1 == 0 || dim2 == 0 || dim3 == 0) {
            return new byte[0][0][0];
        }
        byte[][][] result = new byte[dim1][dim2][dim3];
        int index = 0;
        for (int i = 0; i < dim1; ++i) {
            for (int j = 0; j < dim2; ++j) {
                for (int k = 0; k < dim3; ++k) {
                    result[i][j][k] = flatArray[index++];
                }
            }
        }
        return result;
    }
}

