/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic.helper;

import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import com.igteam.immersivegeology.common.block.multiblocks.logic.RevFurnaceLogic;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.RevFurnaceRecipe;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class IGRevFurnaceHandler<R extends IESerializableRecipe> {
    private int processLeft = 0;
    private int processMaxLeft = 0;
    private int burnTimeLeft = 0;
    private int lastBurnTimeLeft = 0;
    private int processRight = 0;
    private int processMaxRight = 0;
    private int burnTimeRight = 0;
    private int lastBurnTimeRight = 0;
    public final RevStateView stateView = new RevStateView();
    private final int fuelSlotLeft;
    private final int fuelSlotRight;
    private final List<RevInputSlot<R>> inputsLeft;
    private final List<RevOutputSlot<R>> outputsLeft;
    private final ToIntFunction<R> getProcessingTimeLeft;
    private final List<RevInputSlot<R>> inputsRight;
    private final List<RevOutputSlot<R>> outputsRight;
    private final ToIntFunction<R> getProcessingTimeRight;
    private final Runnable setChanged;

    public IGRevFurnaceHandler(int fuelSlotLeft, List<RevInputSlot<R>> inputsLeft, List<RevOutputSlot<R>> outputsLeft, ToIntFunction<R> getProcessingTimeLeft, int fuelSlotRight, List<RevInputSlot<R>> inputsRight, List<RevOutputSlot<R>> outputsRight, ToIntFunction<R> getProcessingTimeRight, Runnable setChanged) {
        this.fuelSlotLeft = fuelSlotLeft;
        this.inputsLeft = inputsLeft;
        this.outputsLeft = outputsLeft;
        this.getProcessingTimeLeft = getProcessingTimeLeft;
        this.fuelSlotRight = fuelSlotRight;
        this.inputsRight = inputsRight;
        this.outputsRight = outputsRight;
        this.getProcessingTimeRight = getProcessingTimeRight;
        this.setChanged = setChanged;
    }

    public boolean tickServerLeft(IMultiblockContext<? extends IRevFurnaceEnvironment<R>> ctx) {
        boolean active = false;
        IRevFurnaceEnvironment env = (IRevFurnaceEnvironment)ctx.getState();
        if (this.burnTimeLeft > 0) {
            R recipe;
            int processSpeed = 1;
            if (this.processLeft > 0) {
                processSpeed = env.getProcessSpeed(ctx.getLevel());
            }
            this.burnTimeLeft -= processSpeed;
            if (this.processLeft > 0) {
                if (this.isAnyInputEmpty((IItemHandler)env.getInventory(), true)) {
                    this.processLeft = 0;
                    this.processMaxLeft = 0;
                } else {
                    recipe = this.getRecipeLeft(env);
                    if (recipe != null && this.getProcessTimeLeft(recipe) != this.processMaxLeft) {
                        this.processMaxLeft = 0;
                        this.processLeft = 0;
                    } else {
                        this.processLeft -= processSpeed;
                        processSpeed = 0;
                        active = true;
                    }
                }
                this.setChanged.run();
            }
            if (this.processLeft <= 0) {
                if (this.processMaxLeft > 0) {
                    this.doRecipeIOLeft(env);
                    this.processMaxLeft = 0;
                    this.burnTimeLeft -= this.processLeft;
                }
                if ((recipe = this.getRecipeLeft(env)) != null) {
                    int time = this.getProcessTimeLeft(recipe);
                    this.processLeft = time - processSpeed;
                    this.processMaxLeft = time;
                    active = true;
                }
            }
        }
        if (this.burnTimeLeft <= 0 && this.getRecipeLeft(env) != null) {
            IItemHandlerModifiable inv = env.getInventory();
            ItemStack fuel = inv.getStackInSlot(this.fuelSlotLeft);
            int addedBurntime = env.getBurnTimeOf(ctx.getLevel().getRawLevel(), fuel);
            if (addedBurntime > 0) {
                this.lastBurnTimeLeft = addedBurntime;
                this.burnTimeLeft += this.lastBurnTimeLeft;
                if (fuel.hasCraftingRemainingItem() && fuel.m_41613_() == 1) {
                    inv.setStackInSlot(this.fuelSlotLeft, fuel.getCraftingRemainingItem());
                } else {
                    fuel.m_41774_(1);
                }
                this.setChanged.run();
            }
        }
        if (!active) {
            env.turnOff(ctx.getLevel(), true);
        }
        return active;
    }

    public boolean tickServerRight(IMultiblockContext<? extends IRevFurnaceEnvironment<R>> ctx) {
        boolean active = false;
        IRevFurnaceEnvironment env = (IRevFurnaceEnvironment)ctx.getState();
        if (this.burnTimeRight > 0) {
            R recipe;
            int processSpeed = 1;
            if (this.processRight > 0) {
                processSpeed = env.getProcessSpeed(ctx.getLevel());
            }
            this.burnTimeRight -= processSpeed;
            if (this.processRight > 0) {
                if (this.isAnyInputEmpty((IItemHandler)env.getInventory(), false)) {
                    this.processRight = 0;
                    this.processMaxRight = 0;
                } else {
                    recipe = this.getRecipeRight(env);
                    if (recipe != null && this.getProcessTimeRight(recipe) != this.processMaxRight) {
                        this.processMaxRight = 0;
                        this.processRight = 0;
                    } else {
                        this.processRight -= processSpeed;
                        processSpeed = 0;
                        active = true;
                    }
                }
                this.setChanged.run();
            }
            if (this.processRight <= 0) {
                if (this.processMaxRight > 0) {
                    this.doRecipeIORight(env);
                    this.processMaxRight = 0;
                    this.burnTimeRight -= this.processRight;
                }
                if ((recipe = this.getRecipeRight(env)) != null) {
                    int time = this.getProcessTimeRight(recipe);
                    this.processRight = time - processSpeed;
                    this.processMaxRight = time;
                    active = true;
                }
            }
        }
        if (this.burnTimeRight <= 0 && this.getRecipeRight(env) != null) {
            IItemHandlerModifiable inv = env.getInventory();
            ItemStack fuel = inv.getStackInSlot(this.fuelSlotRight);
            int addedBurntime = env.getBurnTimeOf(ctx.getLevel().getRawLevel(), fuel);
            if (addedBurntime > 0) {
                this.lastBurnTimeRight = addedBurntime;
                this.burnTimeRight += this.lastBurnTimeRight;
                if (fuel.hasCraftingRemainingItem() && fuel.m_41613_() == 1) {
                    inv.setStackInSlot(this.fuelSlotRight, fuel.getCraftingRemainingItem());
                } else {
                    fuel.m_41774_(1);
                }
                this.setChanged.run();
            }
        }
        if (!active) {
            env.turnOff(ctx.getLevel(), false);
        }
        return active;
    }

    public Tag toNBT() {
        CompoundTag result = new CompoundTag();
        result.m_128405_("processLeft", this.processLeft);
        result.m_128405_("processMaxLeft", this.processMaxLeft);
        result.m_128405_("burnTimeLeft", this.burnTimeLeft);
        result.m_128405_("lastBurnTimeLeft", this.lastBurnTimeLeft);
        result.m_128405_("processRight", this.processRight);
        result.m_128405_("processMaxRight", this.processMaxRight);
        result.m_128405_("burnTimeRight", this.burnTimeRight);
        result.m_128405_("lastBurnTimeRight", this.lastBurnTimeRight);
        return result;
    }

    public void readNBT(Tag nbt) {
        if (!(nbt instanceof CompoundTag)) {
            return;
        }
        CompoundTag compound = (CompoundTag)nbt;
        this.processLeft = compound.m_128451_("processLeft");
        this.processMaxLeft = compound.m_128451_("processMaxLeft");
        this.burnTimeLeft = compound.m_128451_("burnTimeLeft");
        this.lastBurnTimeLeft = compound.m_128451_("lastBurnTimeLeft");
        this.processRight = compound.m_128451_("processRight");
        this.processMaxRight = compound.m_128451_("processMaxRight");
        this.burnTimeRight = compound.m_128451_("burnTimeRight");
        this.lastBurnTimeRight = compound.m_128451_("lastBurnTimeRight");
    }

    private boolean isAnyInputEmpty(IItemHandler inv, boolean isLeft) {
        for (RevInputSlot<R> i : isLeft ? this.inputsLeft : this.inputsRight) {
            if (!inv.getStackInSlot(i.slotIndex).m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private R getRecipeLeft(IRevFurnaceEnvironment<R> env) {
        R recipe = env.getRecipeForInput(true);
        if (recipe == null) {
            return null;
        }
        IItemHandlerModifiable inv = env.getInventory();
        for (RevOutputSlot<R> out : this.outputsLeft) {
            ItemStack currentStack = inv.getStackInSlot(out.slotIndex);
            ItemStack outputSlot = out.get(recipe);
            if (currentStack.m_41619_()) continue;
            if (!ItemStack.m_41656_((ItemStack)currentStack, (ItemStack)outputSlot)) {
                return null;
            }
            if (currentStack.m_41613_() + outputSlot.m_41613_() <= inv.getSlotLimit(out.slotIndex)) continue;
            return null;
        }
        return recipe;
    }

    @Nullable
    private R getRecipeRight(IRevFurnaceEnvironment<R> env) {
        R recipe = env.getRecipeForInput(false);
        if (recipe == null) {
            return null;
        }
        IItemHandlerModifiable inv = env.getInventory();
        for (RevOutputSlot<R> out : this.outputsRight) {
            ItemStack currentStack = inv.getStackInSlot(out.slotIndex);
            ItemStack outputSlot = out.get(recipe);
            if (currentStack.m_41619_()) continue;
            if (!ItemStack.m_41656_((ItemStack)currentStack, (ItemStack)outputSlot)) {
                return null;
            }
            if (currentStack.m_41613_() + outputSlot.m_41613_() <= inv.getSlotLimit(out.slotIndex)) continue;
            return null;
        }
        return recipe;
    }

    private void doRecipeIOLeft(IRevFurnaceEnvironment<R> env) {
        R recipe = this.getRecipeLeft(env);
        if (recipe == null) {
            return;
        }
        IItemHandlerModifiable inv = env.getInventory();
        for (RevInputSlot<R> revInputSlot : this.inputsLeft) {
            int reqSize = this.inputsLeft.stream().map(matchSlot -> matchSlot.get(recipe)).filter(ingr -> ingr.test(inv.getStackInSlot(slot.slotIndex))).mapToInt(IngredientWithSize::getCount).findFirst().orElse(0);
            inv.getStackInSlot(revInputSlot.slotIndex).m_41774_(reqSize);
        }
        for (RevOutputSlot revOutputSlot : this.outputsLeft) {
            ItemStack result = revOutputSlot.get(recipe);
            if (result.m_41619_()) continue;
            if (!inv.getStackInSlot(revOutputSlot.slotIndex).m_41619_()) {
                inv.getStackInSlot(revOutputSlot.slotIndex).m_41769_(result.m_41613_());
                continue;
            }
            inv.setStackInSlot(revOutputSlot.slotIndex, result.m_41777_());
        }
        if (recipe instanceof RevFurnaceRecipe) {
            RevFurnaceRecipe revRecipe = (RevFurnaceRecipe)((Object)recipe);
            if (env instanceof RevFurnaceLogic.State) {
                RevFurnaceLogic.State state = (RevFurnaceLogic.State)env;
                state.addToTank(revRecipe.getWasteAmount());
            }
        }
    }

    private void doRecipeIORight(IRevFurnaceEnvironment<R> env) {
        R recipe = this.getRecipeRight(env);
        if (recipe == null) {
            return;
        }
        IItemHandlerModifiable inv = env.getInventory();
        for (RevInputSlot<R> revInputSlot : this.inputsRight) {
            int reqSize = this.inputsRight.stream().map(matchSlot -> matchSlot.get(recipe)).filter(ingr -> ingr.test(inv.getStackInSlot(slot.slotIndex))).mapToInt(IngredientWithSize::getCount).findFirst().orElse(0);
            inv.getStackInSlot(revInputSlot.slotIndex).m_41774_(reqSize);
        }
        for (RevOutputSlot revOutputSlot : this.outputsRight) {
            ItemStack result = revOutputSlot.get(recipe);
            if (result.m_41619_()) continue;
            if (!inv.getStackInSlot(revOutputSlot.slotIndex).m_41619_()) {
                inv.getStackInSlot(revOutputSlot.slotIndex).m_41769_(result.m_41613_());
                continue;
            }
            inv.setStackInSlot(revOutputSlot.slotIndex, result.m_41777_());
        }
        if (recipe instanceof RevFurnaceRecipe) {
            RevFurnaceRecipe revRecipe = (RevFurnaceRecipe)((Object)recipe);
            if (env instanceof RevFurnaceLogic.State) {
                RevFurnaceLogic.State state = (RevFurnaceLogic.State)env;
                state.addToTank(revRecipe.getWasteAmount());
            }
        }
    }

    private int getProcessTimeLeft(R recipe) {
        return this.getProcessingTimeLeft.applyAsInt(recipe);
    }

    private int getProcessTimeRight(R recipe) {
        return this.getProcessingTimeRight.applyAsInt(recipe);
    }

    public class RevStateView
    implements ContainerData {
        public static final int LAST_BURN_TIME_LEFT = 0;
        public static final int BURN_TIME_LEFT = 1;
        public static final int PROCESS_MAX_LEFT = 2;
        public static final int CURRENT_PROCESS_LEFT = 3;
        public static final int LAST_BURN_TIME_RIGHT = 4;
        public static final int BURN_TIME_RIGHT = 5;
        public static final int PROCESS_MAX_RIGHT = 6;
        public static final int CURRENT_PROCESS_RIGHT = 7;
        public static final int NUM_SLOTS = 8;

        public static int getLastBurnTimeLeft(ContainerData data) {
            return data.m_6413_(0);
        }

        public static int getBurnTimeLeft(ContainerData data) {
            return data.m_6413_(1);
        }

        public static int getMaxProcessLeft(ContainerData data) {
            return data.m_6413_(2);
        }

        public static int getProcessLeft(ContainerData data) {
            return data.m_6413_(3);
        }

        public static int getLastBurnTimeRight(ContainerData data) {
            return data.m_6413_(4);
        }

        public static int getBurnTimeRight(ContainerData data) {
            return data.m_6413_(5);
        }

        public static int getMaxProcessRight(ContainerData data) {
            return data.m_6413_(6);
        }

        public static int getProcessRight(ContainerData data) {
            return data.m_6413_(7);
        }

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> IGRevFurnaceHandler.this.lastBurnTimeLeft;
                case 1 -> IGRevFurnaceHandler.this.burnTimeLeft;
                case 2 -> IGRevFurnaceHandler.this.processMaxLeft;
                case 3 -> IGRevFurnaceHandler.this.processLeft;
                case 4 -> IGRevFurnaceHandler.this.lastBurnTimeRight;
                case 5 -> IGRevFurnaceHandler.this.burnTimeRight;
                case 6 -> IGRevFurnaceHandler.this.processMaxRight;
                case 7 -> IGRevFurnaceHandler.this.processRight;
                default -> throw new IllegalArgumentException("Unknown index " + index);
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    IGRevFurnaceHandler.this.lastBurnTimeLeft = value;
                    break;
                }
                case 1: {
                    IGRevFurnaceHandler.this.burnTimeLeft = value;
                    break;
                }
                case 2: {
                    IGRevFurnaceHandler.this.processMaxLeft = value;
                    break;
                }
                case 3: {
                    IGRevFurnaceHandler.this.processLeft = value;
                    break;
                }
                case 4: {
                    IGRevFurnaceHandler.this.lastBurnTimeRight = value;
                    break;
                }
                case 5: {
                    IGRevFurnaceHandler.this.burnTimeRight = value;
                    break;
                }
                case 6: {
                    IGRevFurnaceHandler.this.processMaxRight = value;
                    break;
                }
                case 7: {
                    IGRevFurnaceHandler.this.processRight = value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown index " + index);
                }
            }
        }

        public int m_6499_() {
            return 8;
        }
    }

    public static interface IRevFurnaceEnvironment<R extends IESerializableRecipe> {
        public IItemHandlerModifiable getInventory();

        @Nullable
        public R getRecipeForInput(boolean var1);

        public int getBurnTimeOf(Level var1, ItemStack var2);

        default public int getProcessSpeed(IMultiblockLevel level) {
            return 1;
        }

        default public void turnOff(IMultiblockLevel level, boolean isLeft) {
        }
    }

    public static class RevInputSlot<R> {
        private final Function<R, IngredientWithSize> getFromRecipe;
        private final int slotIndex;

        public RevInputSlot(Function<R, IngredientWithSize> getFromRecipe, int slotIndex) {
            this.getFromRecipe = getFromRecipe;
            this.slotIndex = slotIndex;
        }

        public IngredientWithSize get(R recipe) {
            return this.getFromRecipe.apply(recipe);
        }
    }

    public static class RevOutputSlot<R> {
        private final Function<R, Lazy<ItemStack>> getFromRecipe;
        private final int slotIndex;

        public RevOutputSlot(Function<R, Lazy<ItemStack>> getFromRecipe, int slotIndex) {
            this.getFromRecipe = getFromRecipe;
            this.slotIndex = slotIndex;
        }

        public ItemStack get(R recipe) {
            return (ItemStack)this.getFromRecipe.apply(recipe).get();
        }
    }
}

