/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic.helper;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import com.igteam.immersivegeology.common.block.multiblocks.logic.RotaryKilnLogic;
import net.minecraft.world.level.Level;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RotaryKilnHeatState {
    HEATING_UP{

        @Override
        public void execute(IMultiblockContext<RotaryKilnLogic.State> context) {
            RotaryKilnLogic.State state = (RotaryKilnLogic.State)context.getState();
            Level level = context.getLevel().getRawLevel();
            int energy = state.total_energy.getEnergyStored();
            float currentHeat = state.getHeat();
            float targetHeat = state.getTargetHeat();
            int processing = state.getProcessorQueue().size();
            int energyCostToRaiseHeat = RotaryKilnHeatState.energyCostForHeat(currentHeat);
            if (energy > energyCostToRaiseHeat) {
                state.total_energy.extractEnergy(energyCostToRaiseHeat, false);
                state.modifyHeat(0.7f - 0.05f * (float)processing);
            } else {
                state.modifyHeat(-0.5f * (float)processing);
            }
        }
    }
    ,
    COOLING_DOWN{

        @Override
        public void execute(IMultiblockContext<RotaryKilnLogic.State> context) {
            RotaryKilnLogic.State state = (RotaryKilnLogic.State)context.getState();
            float currentHeat = state.getHeat();
            if (currentHeat > 0.0f) {
                state.modifyHeat(-0.05f);
            }
            if (currentHeat < 0.0f) {
                state.setHeat(0.0f);
            }
        }
    }
    ,
    MACHINE_OFF{

        @Override
        public void execute(IMultiblockContext<RotaryKilnLogic.State> context) {
            RotaryKilnLogic.State state = (RotaryKilnLogic.State)context.getState();
            float currentHeat = state.getHeat();
            if (currentHeat > 0.0f) {
                state.modifyHeat(-1.0f);
            }
            if (currentHeat < 0.0f) {
                state.setHeat(0.0f);
            }
        }
    }
    ,
    MAINTAINING_HEAT{

        @Override
        public void execute(IMultiblockContext<RotaryKilnLogic.State> context) {
            RotaryKilnLogic.State state = (RotaryKilnLogic.State)context.getState();
            Level level = context.getLevel().getRawLevel();
            int energy = state.total_energy.getEnergyStored();
            float currentHeat = state.getHeat();
            float targetHeat = state.getTargetHeat();
            int energyCostToRaiseHeat = (int)((float)RotaryKilnHeatState.energyCostForHeat(currentHeat) * 0.9f);
            if (energy > energyCostToRaiseHeat) {
                state.total_energy.extractEnergy(energyCostToRaiseHeat, false);
                float modDir = -1.0f;
                if (currentHeat < targetHeat) {
                    modDir = 1.0f;
                }
                state.modifyHeat(modDir * 0.02f);
                return;
            }
            state.modifyHeat(-0.6f);
        }
    }
    ,
    RUNNING_RECIPE{

        @Override
        public void execute(IMultiblockContext<RotaryKilnLogic.State> context) {
            RotaryKilnLogic.State state = (RotaryKilnLogic.State)context.getState();
            int energy = state.total_energy.getEnergyStored();
            float currentHeat = state.getHeat();
            int processing = state.getProcessorQueue().size();
            int energyCostToRaiseHeat = (int)((float)RotaryKilnHeatState.energyCostForHeat(currentHeat) * 0.9f);
            if (energy > energyCostToRaiseHeat) {
                state.total_energy.extractEnergy(energyCostToRaiseHeat, false);
                return;
            }
            state.modifyHeat(-0.5f * (float)processing);
        }
    };

    private static final float lv_heat_target = 45.0f;
    private static final float mv_heat_target = 75.0f;
    private static final float hv_heat_target = 145.0f;
    private static final float ehv_heat_target = 165.0f;
    private static final float lv_cost_cutoff = 5.0f;
    private static final float mv_cost_cutoff = 31.0f;
    private static final float hv_cost_cutoff = 76.0f;
    private static final float ehv_cost_cutoff = 121.0f;

    public void execute(IMultiblockContext<RotaryKilnLogic.State> context) {
    }

    private static int energyCostForHeat(float heat) {
        int upkeepCost = 0;
        if (heat > 5.0f) {
            upkeepCost += 250;
        }
        if (heat > 31.0f) {
            upkeepCost += 500;
        }
        if (heat > 76.0f) {
            upkeepCost += 2250;
        }
        if (heat > 121.0f) {
            upkeepCost += 8000;
        }
        return upkeepCost;
    }
}

