/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic.helper;

import com.igteam.immersivegeology.common.block.multiblocks.recipe.GravitySeparatorRecipe;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class SeparatorProcess {
    private final ItemStack input;
    private RecipeDependentData recipeDependentData;
    private int processTick;
    private boolean processFinished = false;

    public SeparatorProcess(ItemStack input) {
        this.input = input;
    }

    private RecipeDependentData getRecipeDependentData(Level level) {
        if (this.recipeDependentData == null) {
            GravitySeparatorRecipe recipe = GravitySeparatorRecipe.findRecipe(level, this.input);
            if (recipe != null) {
                this.recipeDependentData = new RecipeDependentData(recipe, recipe.getTotalProcessTime(), recipe.getTotalProcessWater() / recipe.getTotalProcessTime());
            }
        } else if (this.recipeDependentData.recipe == null) {
            this.recipeDependentData = null;
        }
        return this.recipeDependentData;
    }

    public boolean processStep(Level level, FluidTank tank) {
        RecipeDependentData data = this.getRecipeDependentData(level);
        if (data == null) {
            return false;
        }
        if (tank.drain(data.waterPerTick, IFluidHandler.FluidAction.SIMULATE).getAmount() < data.waterPerTick) {
            return false;
        }
        if (this.recipeDependentData.recipe == null) {
            return false;
        }
        tank.drain(data.waterPerTick, IFluidHandler.FluidAction.EXECUTE);
        ++this.processTick;
        float relative = this.getRelativeProcessStep(level);
        if (relative >= 1.0f) {
            this.processFinished = true;
        }
        return true;
    }

    public ItemStack getCurrentOutput() {
        if (this.recipeDependentData.recipe != null) {
            return (ItemStack)this.recipeDependentData.recipe.itemOutput.get();
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getCurrentByproduct() {
        if (this.recipeDependentData.recipe != null) {
            return (ItemStack)this.recipeDependentData.recipe.itemByproduct.get();
        }
        return ItemStack.f_41583_;
    }

    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("input", (Tag)this.input.m_41739_(new CompoundTag()));
        nbt.m_128405_("processTick", this.processTick);
        return nbt;
    }

    public static SeparatorProcess readFromNBT(CompoundTag nbt) {
        ItemStack input = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("input"));
        SeparatorProcess process = new SeparatorProcess(input);
        process.processTick = nbt.m_128451_("processTick");
        return process;
    }

    public boolean isProcessFinished() {
        return this.processFinished;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public void incrementProcessOnClient() {
        ++this.processTick;
    }

    public float getRelativeProcessStep(Level level) {
        return (float)this.processTick / this.getRecipeDependentData((Level)level).maxProcessTicks;
    }

    public boolean outputByproduct() {
        Random rand = new Random();
        return this.recipeDependentData.recipe != null && this.recipeDependentData.recipe.getChance() > rand.nextFloat();
    }

    private record RecipeDependentData(GravitySeparatorRecipe recipe, float maxProcessTicks, int waterPerTick) {
    }
}

