/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.part;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockPartBlock;
import com.igteam.immersivegeology.common.block.multiblocks.IGTemplateMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGMultiblockState;
import com.igteam.immersivegeology.common.block.multiblocks.skins.helpers.IIGMultiSkinHelper;
import com.igteam.immersivegeology.common.block.multiblocks.skins.helpers.IMultiSkinBlock;
import com.igteam.immersivegeology.common.config.IGServerConfig;
import com.igteam.immersivegeology.core.lib.IGLib;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public abstract class SkinableMultiblockPart<S extends IMultiblockState, T extends Enum<T> & StringRepresentable>
extends MultiblockPartBlock<S>
implements IMultiSkinBlock<T> {
    private final EnumProperty<T> skinProperty;
    private final Class<T> skinClass;
    private final String textureDir;

    protected SkinableMultiblockPart(BlockBehaviour.Properties props, MultiblockRegistration<S> reg, EnumProperty<T> skinProperty, Class<T> skinClass, String textureDir) {
        super(props, reg);
        this.skinProperty = skinProperty;
        this.skinClass = skinClass;
        this.textureDir = textureDir;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)IEProperties.MIRRORED, (Comparable)Boolean.valueOf(false))).m_61124_(skinProperty, (Comparable)((Object)((Enum[])skinClass.getEnumConstants())[0])));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{IEProperties.MIRRORED});
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        IMultiblockBE be;
        IMultiblockBEHelper helper;
        IMultiblockState mbState;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiblockBE && (mbState = (helper = (be = (IMultiblockBE)blockEntity).getHelper()).getState()) instanceof IGMultiblockState) {
            IGMultiblockState igState = (IGMultiblockState)mbState;
            if (helper.getContext() != null) {
                igState.invalidate(helper.getContext());
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        String multiblock;
        IGServerConfig.Machines.MachineConfig config;
        if (!pMovedByPiston && (config = IGServerConfig.MACHINES.machines.get(multiblock = ((IIGMultiSkinHelper)((Object)((Enum[])this.skinClass.getEnumConstants())[0])).multiblockName())) != null) {
            int skin_ordinal = (Integer)config.default_skin_ordinal.get() % ((Enum[])this.skinClass.getEnumConstants()).length;
            BlockState state = (BlockState)pState.m_61124_(this.skinProperty, (Comparable)((Object)((Enum[])this.skinClass.getEnumConstants())[skin_ordinal]));
            pLevel.m_7731_(pPos, state, 3);
        }
        super.m_6807_(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }

    @Override
    public EnumProperty<T> getSkinProperty() {
        return this.skinProperty;
    }

    @Override
    public Class<T> getSkinClass() {
        return this.skinClass;
    }

    public String getTextureDir() {
        return this.textureDir;
    }

    public static <T extends Enum<T> & StringRepresentable> boolean setSkin(IMultiblockLevel level, IGTemplateMultiblock template, Enum<?> skinValue) {
        try {
            Block block = template.getBlock();
            if (!(block instanceof IMultiSkinBlock)) {
                return false;
            }
            IMultiSkinBlock raw = (IMultiSkinBlock)block;
            IMultiSkinBlock skinnable = raw;
            EnumProperty prop = skinnable.getSkinProperty();
            Level rawLevel = level.getRawLevel();
            BlockPos.MutableBlockPos realPos = new BlockPos.MutableBlockPos();
            for (StructureTemplate.StructureBlockInfo info : template.getStructure(level.getRawLevel())) {
                BlockPos pos = info.f_74675_();
                BlockState current = level.getBlockState(pos);
                if (!current.m_60713_(block)) continue;
                BlockPos wpos = level.toAbsolute(pos);
                rawLevel.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)((float)wpos.m_123341_() + 0.5f), (double)((float)wpos.m_123342_() + 0.5f), (double)((float)wpos.m_123343_() + 0.5f), 0.0, 0.0625, 0.0);
                realPos.m_122190_((Vec3i)wpos);
                Optional<Property.Value> value = prop.m_61702_().filter(p -> ((Enum)((Object)p.f_61713_())).equals(skinValue)).findFirst();
                if (value.isEmpty()) continue;
                if (((Enum)((Object)current.m_61143_(prop))).equals(skinValue)) {
                    Class<?> skinClass = skinValue.getDeclaringClass();
                    String multiblock = ((IIGMultiSkinHelper)((Object)((Enum[])skinClass.getEnumConstants())[0])).multiblockName();
                    IGServerConfig.Machines.MachineConfig config = IGServerConfig.MACHINES.machines.get(multiblock);
                    int skin_ordinal = (Integer)config.default_skin_ordinal.get() % ((Enum[])skinClass.getEnumConstants()).length;
                    if (((Enum[])skinClass.getEnumConstants())[skin_ordinal].equals(skinValue)) {
                        return false;
                    }
                    BlockState state = (BlockState)current.m_61124_(prop, (Comparable)((Object)((Enum[])skinClass.getEnumConstants())[skin_ordinal]));
                    rawLevel.m_7731_((BlockPos)realPos, state, 67);
                    continue;
                }
                BlockState updated = (BlockState)current.m_61124_(prop, (Comparable)((Object)((Enum)((Object)value.get().f_61713_()))));
                rawLevel.m_7731_((BlockPos)realPos, updated, 67);
            }
        }
        catch (Exception error) {
            IGLib.IG_LOGGER.warn("Failed to update Multiblock Skin, please send this error report to the IG discord or IG Github Issues!");
            IGLib.IG_LOGGER.error("Error Message: {}", (Object)error.getMessage());
        }
        return true;
    }
}

