/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.igteam.immersivegeology.core.registration.IGRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;

public class CrystallizerRecipe
extends MultiblockRecipe {
    public static RegistryObject<IERecipeSerializer<CrystallizerRecipe>> SERIALIZER;
    public static final CachedRecipeList<CrystallizerRecipe> RECIPES;
    public final Lazy<ItemStack> itemOutput;
    public final Lazy<FluidStack> fluidOutput;
    public final FluidTagInput fluidIn;
    Lazy<Integer> totalProcessEnergy;
    Lazy<Integer> totalProcessTime;

    public <T extends Recipe<?>> CrystallizerRecipe(ResourceLocation id, FluidTagInput fluidInput, Lazy<ItemStack> output, Lazy<FluidStack> fluid_output, int energy, int time) {
        super(LAZY_EMPTY, IGRecipeTypes.CRYSTALLIZER, id);
        this.itemOutput = output;
        this.fluidIn = fluidInput;
        this.totalProcessEnergy = Lazy.of(() -> energy);
        this.totalProcessTime = Lazy.of(() -> time);
        this.fluidOutput = fluid_output;
        this.outputList = Lazy.of(() -> NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{(ItemStack)this.itemOutput.get()}));
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public int getTotalProcessEnergy() {
        return (Integer)this.totalProcessEnergy.get();
    }

    public int getTotalProcessTime() {
        return (Integer)this.totalProcessTime.get();
    }

    public static CrystallizerRecipe findRecipe(Level level, FluidStack input) {
        for (CrystallizerRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.fluidIn.test(input)) continue;
            return recipe;
        }
        return null;
    }

    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public int getMultipleProcessTicks() {
        return 1;
    }

    static {
        RECIPES = new CachedRecipeList(IGRecipeTypes.CRYSTALLIZER);
    }
}

