/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IJEIRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.igteam.immersivegeology.core.registration.IGRecipeTypes;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeothermalConversionRecipe
extends IESerializableRecipe
implements IJEIRecipe {
    public static RegistryObject<IERecipeSerializer<GeothermalConversionRecipe>> SERIALIZER;
    public static final CachedRecipeList<GeothermalConversionRecipe> RECIPES;
    private static HashSet<Block> usedBlocks;
    public final Lazy<Block> transitionBlock;
    public final int blockHeat;
    @Nullable
    public final Block upperTransition;
    @Nullable
    public Integer upperHeat;
    @Nullable
    public Block lowerTransition;
    @Nullable
    public Integer lowerHeat;

    public <T extends Recipe<?>> GeothermalConversionRecipe(ResourceLocation id, Lazy<Block> transitionaryBlock, int blockHeat, @Nullable Pair<Block, Integer> upperBound, @Nullable Pair<Block, Integer> lowerBound) {
        super(LAZY_EMPTY, IGRecipeTypes.GEOTHERMAL_EXCHANGER_CONVERTION, id);
        this.transitionBlock = transitionaryBlock;
        this.blockHeat = blockHeat;
        this.upperTransition = upperBound == null ? null : (Block)upperBound.getFirst();
        this.upperHeat = upperBound == null ? null : (Integer)upperBound.getSecond();
        this.lowerTransition = lowerBound == null ? null : (Block)lowerBound.getFirst();
        this.lowerHeat = lowerBound == null ? null : (Integer)lowerBound.getSecond();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public static GeothermalConversionRecipe findRecipe(Level level, Block block) {
        for (GeothermalConversionRecipe recipe : RECIPES.getRecipes(level)) {
            if (!((Block)recipe.transitionBlock.get()).equals(block)) continue;
            FluidState fluidState = block.m_49966_().m_60819_();
            if (!fluidState.m_76178_()) {
                if (fluidState.m_76170_()) {
                    return recipe;
                }
                return null;
            }
            return recipe;
        }
        return null;
    }

    public static GeothermalConversionRecipe findRecipe(Level level, int blockIndex) {
        if (blockIndex == -1) {
            return null;
        }
        int i = 0;
        for (GeothermalConversionRecipe recipe : RECIPES.getRecipes(level)) {
            if (i == blockIndex) {
                return recipe;
            }
            ++i;
        }
        return null;
    }

    @NotNull
    public static Block getBlockFromIndex(Level level, int blockIndex) {
        GeothermalConversionRecipe recipe = GeothermalConversionRecipe.findRecipe(level, blockIndex);
        if (recipe == null) {
            return Blocks.f_50016_;
        }
        return (Block)recipe.transitionBlock.get();
    }

    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public List<Block> getMatchingBlocks() {
        if (this.upperTransition != null && this.lowerTransition != null) {
            return List.of((Block)this.transitionBlock.get(), this.upperTransition, this.lowerTransition);
        }
        if (this.upperTransition != null) {
            return List.of((Block)this.transitionBlock.get(), this.upperTransition, Blocks.f_50375_);
        }
        if (this.lowerTransition != null) {
            return List.of((Block)this.transitionBlock.get(), Blocks.f_50375_, this.lowerTransition);
        }
        return List.of((Block)this.transitionBlock.get(), Blocks.f_50375_, Blocks.f_50375_);
    }

    static {
        RECIPES = new CachedRecipeList(IGRecipeTypes.GEOTHERMAL_EXCHANGER_CONVERTION);
        usedBlocks = new HashSet();
    }
}

