/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.utils.FastEither;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.igteam.immersivegeology.core.registration.IGRecipeTypes;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class TurbineFuel
extends IESerializableRecipe {
    public static RegistryObject<IERecipeSerializer<TurbineFuel>> SERIALIZER;
    public static final CachedRecipeList<TurbineFuel> RECIPES;
    private final FastEither<TagKey<Fluid>, List<Fluid>> fluids;
    private final int burnTime;
    private final int consume_amount;
    private final float outputRatio;

    public TurbineFuel(ResourceLocation id, TagKey<Fluid> fluids, float outputRatio, int consume_amount, int burnTime) {
        super(LAZY_EMPTY, IGRecipeTypes.TURBINE_FUEL, id);
        this.fluids = FastEither.left(fluids);
        this.burnTime = burnTime;
        this.outputRatio = outputRatio;
        this.consume_amount = consume_amount;
    }

    public TurbineFuel(ResourceLocation id, List<Fluid> fluids, float outputRatio, int consume_amount, int burnTime) {
        super(LAZY_EMPTY, IGRecipeTypes.TURBINE_FUEL, id);
        this.fluids = FastEither.right(fluids);
        this.burnTime = burnTime;
        this.consume_amount = consume_amount;
        this.outputRatio = outputRatio;
    }

    public List<Fluid> getFluids() {
        return (List)this.fluids.map(t -> TagUtils.elementStream((Registry)BuiltInRegistries.f_257020_, (TagKey)t).toList(), Function.identity());
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getConsumed() {
        return this.consume_amount;
    }

    public float getOutputRatio() {
        return this.outputRatio;
    }

    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Nonnull
    public ItemStack m_8043_(@NotNull RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public boolean matches(Fluid in) {
        return this.fluids.isLeft() ? in.m_205067_((TagKey)this.fluids.leftNonnull()) : ((List)this.fluids.rightNonnull()).contains(in);
    }

    public static TurbineFuel getRecipeFor(Level level, Fluid in, @Nullable TurbineFuel hint) {
        TurbineFuel fuel;
        if (hint != null && hint.matches(in)) {
            return hint;
        }
        Iterator var3 = RECIPES.getRecipes(level).iterator();
        do {
            if (var3.hasNext()) continue;
            return null;
        } while (!(fuel = (TurbineFuel)((Object)var3.next())).matches(in));
        return fuel;
    }

    public static SortedMap<Component, Integer> getManualFuelList(Level level) {
        TreeMap<Component, Integer> map = new TreeMap<Component, Integer>(Comparator.comparing(Component::getString, Comparator.naturalOrder()));
        for (TurbineFuel recipe : RECIPES.getRecipes(level)) {
            for (Fluid f : recipe.getFluids()) {
                map.put(f.getFluidType().getDescription(), recipe.getBurnTime());
            }
        }
        return map;
    }

    static {
        RECIPES = new CachedRecipeList(IGRecipeTypes.TURBINE_FUEL);
    }
}

