/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe.serializer;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.CentrifugeRecipe;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class CentrifugeRecipeSerializer
extends IERecipeSerializer<CentrifugeRecipe> {
    public ItemStack getIcon() {
        return IGMultiblockProvider.CENTRIFUGE.iconStack();
    }

    public CentrifugeRecipe readFromJson(ResourceLocation resourceLocation, JsonObject json, ICondition.IContext iContext) {
        FluidTagInput input = FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"fluid_input"));
        Lazy output = CentrifugeRecipeSerializer.readOutput((JsonElement)json.get("item_output"));
        FluidStack primary_fluid_output = ApiUtils.jsonDeserializeFluidStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"primary_fluid_out"));
        FluidStack secondary_fluid_output = ApiUtils.jsonDeserializeFluidStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"secondary_fluid_out"));
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        return new CentrifugeRecipe(resourceLocation, input, (Lazy<ItemStack>)output, (Lazy<FluidStack>)((Lazy)() -> primary_fluid_output), (Lazy<FluidStack>)((Lazy)() -> secondary_fluid_output), energy, time);
    }

    @Nullable
    public CentrifugeRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
        FluidTagInput input = FluidTagInput.read((FriendlyByteBuf)buffer);
        Lazy output = CentrifugeRecipeSerializer.readLazyStack((FriendlyByteBuf)buffer);
        FluidStack primaryFluidOutput = buffer.readFluidStack();
        FluidStack secondaryFluidOutput = buffer.readFluidStack();
        int energy = buffer.readInt();
        int time = buffer.readInt();
        return new CentrifugeRecipe(resourceLocation, input, (Lazy<ItemStack>)output, (Lazy<FluidStack>)((Lazy)() -> primaryFluidOutput), (Lazy<FluidStack>)((Lazy)() -> secondaryFluidOutput), energy, time);
    }

    public void toNetwork(FriendlyByteBuf buffer, CentrifugeRecipe recipe) {
        recipe.fluidIn.write(buffer);
        CentrifugeRecipeSerializer.writeLazyStack((FriendlyByteBuf)buffer, recipe.itemOutput);
        buffer.writeFluidStack((FluidStack)recipe.primaryFluidOutput.get());
        buffer.writeFluidStack((FluidStack)recipe.secondaryFluidOutput.get());
        buffer.writeInt(recipe.getTotalProcessEnergy());
        buffer.writeInt(recipe.getTotalProcessTime());
    }
}

