/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe.serializer;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.ChemicalRecipe;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.HashSet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class ChemicalRecipeSerializer
extends IERecipeSerializer<ChemicalRecipe> {
    public ItemStack getIcon() {
        return IGMultiblockProvider.CHEMICAL_REACTOR.iconStack();
    }

    public ChemicalRecipe readFromJson(ResourceLocation resourceLocation, JsonObject json, ICondition.IContext iContext) {
        Lazy output = ChemicalRecipeSerializer.readOutput((JsonElement)json.get("result"));
        FluidStack fluidOut = ApiUtils.jsonDeserializeFluidStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"fluidResult"));
        IngredientWithSize itemInput = IngredientWithSize.deserialize((JsonElement)json.get("itemInput"));
        HashSet<FluidTagInput> fluidSet = new HashSet<FluidTagInput>();
        if (GsonHelper.m_13900_((JsonObject)json, (String)"fluidInputA")) {
            fluidSet.add(FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"fluidInputA")));
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"fluidInputB")) {
            fluidSet.add(FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"fluidInputB")));
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"fluidInputC")) {
            fluidSet.add(FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"fluidInputC")));
        }
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        ItemStack outputStack = ItemStack.f_41583_;
        try {
            outputStack = (ItemStack)output.get();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return new ChemicalRecipe(resourceLocation, itemInput, fluidSet, outputStack, fluidOut, energy, time);
    }

    @Nullable
    public ChemicalRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
        ItemStack output = buffer.m_130267_();
        FluidStack fluidOut = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        IngredientWithSize itemInput = IngredientWithSize.read((FriendlyByteBuf)buffer);
        HashSet<FluidTagInput> fluidSet = new HashSet<FluidTagInput>();
        int fluid_input_size = buffer.readInt();
        for (int i = 0; i < fluid_input_size; ++i) {
            FluidTagInput fluid = FluidTagInput.read((FriendlyByteBuf)buffer);
            fluidSet.add(fluid);
        }
        int energy = buffer.readInt();
        int time = buffer.readInt();
        return new ChemicalRecipe(resourceLocation, itemInput, fluidSet, output, fluidOut, energy, time);
    }

    public void toNetwork(FriendlyByteBuf buffer, ChemicalRecipe recipe) {
        buffer.writeItemStack(recipe.itemOutput, false);
        recipe.fluidOutput.writeToPacket(buffer);
        recipe.itemInput.write(buffer);
        buffer.writeInt(recipe.fluidIn.size());
        recipe.fluidIn.forEach(f -> f.write(buffer));
        buffer.writeInt(recipe.getTotalProcessEnergy());
        int time = recipe.getTotalProcessTime();
        buffer.writeInt(time);
    }
}

