/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe.serializer;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.CrystallizerRecipe;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class CrystallizerRecipeSerializer
extends IERecipeSerializer<CrystallizerRecipe> {
    public ItemStack getIcon() {
        return IGMultiblockProvider.CRYSTALLIZER.iconStack();
    }

    public CrystallizerRecipe readFromJson(ResourceLocation resourceLocation, JsonObject json, ICondition.IContext iContext) {
        Lazy output = CrystallizerRecipeSerializer.readOutput((JsonElement)json.get("result"));
        FluidStack fluid_output = ApiUtils.jsonDeserializeFluidStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"fluidResult"));
        FluidTagInput input = FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        return new CrystallizerRecipe(resourceLocation, input, (Lazy<ItemStack>)output, (Lazy<FluidStack>)((Lazy)() -> fluid_output), energy, time);
    }

    @Nullable
    public CrystallizerRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
        Lazy output = CrystallizerRecipeSerializer.readLazyStack((FriendlyByteBuf)buffer);
        FluidStack fluid_output = buffer.readFluidStack();
        FluidTagInput input = FluidTagInput.read((FriendlyByteBuf)buffer);
        int energy = buffer.readInt();
        int time = buffer.readInt();
        return new CrystallizerRecipe(resourceLocation, input, (Lazy<ItemStack>)output, (Lazy<FluidStack>)((Lazy)() -> fluid_output), energy, time);
    }

    public void toNetwork(FriendlyByteBuf buffer, CrystallizerRecipe recipe) {
        CrystallizerRecipeSerializer.writeLazyStack((FriendlyByteBuf)buffer, recipe.itemOutput);
        buffer.writeFluidStack((FluidStack)recipe.fluidOutput.get());
        recipe.fluidIn.write(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
        buffer.writeInt(recipe.getTotalProcessTime());
    }
}

