/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe.serializer;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.FoundryRecipe;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FoundryRecipeSerializer
extends IERecipeSerializer<FoundryRecipe> {
    public ItemStack getIcon() {
        return IGMultiblockProvider.FOUNDRY.iconStack();
    }

    public FoundryRecipe readFromJson(ResourceLocation resourceLocation, JsonObject json, ICondition.IContext iContext) {
        Lazy output = FoundryRecipeSerializer.readOutput((JsonElement)json.get("result"));
        FluidTagInput input = FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        Item mold = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"mold")));
        return new FoundryRecipe(resourceLocation, input, (Lazy<ItemStack>)output, mold, energy, time);
    }

    @Nullable
    public FoundryRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
        Lazy output = FoundryRecipeSerializer.readLazyStack((FriendlyByteBuf)buffer);
        FluidTagInput input = FluidTagInput.read((FriendlyByteBuf)buffer);
        int energy = buffer.readInt();
        int time = buffer.readInt();
        Item mold = (Item)buffer.readRegistryIdSafe(Item.class);
        return new FoundryRecipe(resourceLocation, input, (Lazy<ItemStack>)output, mold, energy, time);
    }

    public void toNetwork(FriendlyByteBuf buffer, FoundryRecipe recipe) {
        FoundryRecipeSerializer.writeLazyStack((FriendlyByteBuf)buffer, recipe.itemOutput);
        recipe.fluidIn.write(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
        buffer.writeInt(recipe.getTotalProcessTime());
        buffer.writeRegistryId(ForgeRegistries.ITEMS, (Object)recipe.mold);
    }
}

