/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe.serializer;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.GeothermalBiomeRecipe;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class GeothermalBiomeRecipeSerializer
extends IERecipeSerializer<GeothermalBiomeRecipe> {
    public ItemStack getIcon() {
        return IGMultiblockProvider.GEOTHERMAL_EXCHANGER.iconStack();
    }

    public GeothermalBiomeRecipe readFromJson(ResourceLocation id, JsonObject json, ICondition.IContext context) {
        if (json.has("biome") && json.has("biome_tags")) {
            throw new JsonParseException("GeothermalBiomeRecipe must have either 'biome' or 'biome_tags', not both.");
        }
        if (json.has("biome")) {
            ResourceLocation biomeId = new ResourceLocation(json.get("biome").getAsString());
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(biomeId);
            Preconditions.checkNotNull((Object)biome, (String)"Biome '%s' not found", (Object)biomeId);
            int min_heat = json.get("min_heat").getAsInt();
            int max_heat = json.get("max_heat").getAsInt();
            return new GeothermalBiomeRecipe(id, biome, min_heat, max_heat);
        }
        if (json.has("biome_tags")) {
            JsonArray tagArray = json.getAsJsonArray("biome_tags");
            ArrayList<TagKey<Biome>> tags = new ArrayList<TagKey<Biome>>();
            for (JsonElement el : tagArray) {
                ResourceLocation tagId = new ResourceLocation(el.getAsString());
                tags.add(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)tagId));
            }
            int min_heat = json.get("min_heat").getAsInt();
            int max_heat = json.get("max_heat").getAsInt();
            return new GeothermalBiomeRecipe(id, tags, min_heat, max_heat);
        }
        throw new JsonParseException("Missing required field 'biome' or 'biome_tags' in GeothermalBiomeRecipe.");
    }

    @Nullable
    public GeothermalBiomeRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        boolean isSingleBiome = buffer.readBoolean();
        if (isSingleBiome) {
            Biome biome = (Biome)buffer.readRegistryIdUnsafe(ForgeRegistries.BIOMES);
            int min_heat = buffer.readInt();
            int max_heat = buffer.readInt();
            return new GeothermalBiomeRecipe(id, biome, min_heat, max_heat);
        }
        int count = buffer.m_130242_();
        ArrayList<TagKey<Biome>> tags = new ArrayList<TagKey<Biome>>();
        for (int i = 0; i < count; ++i) {
            ResourceLocation tagId = buffer.m_130281_();
            tags.add(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)tagId));
        }
        int min_heat = buffer.readInt();
        int max_heat = buffer.readInt();
        return new GeothermalBiomeRecipe(id, tags, min_heat, max_heat);
    }

    public void toNetwork(FriendlyByteBuf buffer, GeothermalBiomeRecipe recipe) {
        List<TagKey<Biome>> tags = recipe.getBiomes();
        if (recipe.biomes.isLeft()) {
            buffer.writeBoolean(true);
            Biome biome = (Biome)recipe.biomes.leftNonnull();
            buffer.writeRegistryIdUnsafe(ForgeRegistries.BIOMES, (Object)biome);
            buffer.writeInt(recipe.getMinHeat());
            buffer.writeInt(recipe.getMaxHeat());
        } else {
            buffer.writeBoolean(false);
            buffer.m_130130_(tags.size());
            for (TagKey<Biome> tag : tags) {
                buffer.m_130085_(tag.f_203868_());
            }
            buffer.writeInt(recipe.getMinHeat());
            buffer.writeInt(recipe.getMaxHeat());
        }
    }
}

