/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe.serializer;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.GeothermalConversionRecipe;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class GeothermalConversionRecipeSerializer
extends IERecipeSerializer<GeothermalConversionRecipe> {
    public ItemStack getIcon() {
        return IGMultiblockProvider.GEOTHERMAL_EXCHANGER.iconStack();
    }

    public GeothermalConversionRecipe readFromJson(ResourceLocation resourceLocation, JsonObject json, ICondition.IContext iContext) {
        int upperHeat;
        ResourceLocation transitionBlockName = new ResourceLocation(json.get("transitionBlock").getAsString());
        Block transitionBlock = (Block)Preconditions.checkNotNull((Object)((Block)ForgeRegistries.BLOCKS.getValue(transitionBlockName)));
        int transitionBlockHeat = json.get("blockHeat").getAsInt();
        boolean hasUpper = json.has("upperBoundBlock");
        boolean hasLower = json.has("lowerBoundBlock");
        Pair upperBound = null;
        Pair lowerBound = null;
        if (hasUpper) {
            ResourceLocation upperBoundBlockName = new ResourceLocation(json.get("upperBoundBlock").getAsString());
            Block upperBlock = (Block)Preconditions.checkNotNull((Object)((Block)ForgeRegistries.BLOCKS.getValue(upperBoundBlockName)));
            upperHeat = json.get("upperHeat").getAsInt();
            upperBound = Pair.of((Object)upperBlock, (Object)upperHeat);
        }
        if (hasLower) {
            ResourceLocation lowerBoundBlockName = new ResourceLocation(json.get("lowerBoundBlock").getAsString());
            Block lowerBoundBlock = (Block)Preconditions.checkNotNull((Object)((Block)ForgeRegistries.BLOCKS.getValue(lowerBoundBlockName)));
            upperHeat = json.get("lowerHeat").getAsInt();
            lowerBound = Pair.of((Object)lowerBoundBlock, (Object)upperHeat);
        }
        return new GeothermalConversionRecipe(resourceLocation, (Lazy<Block>)((Lazy)() -> transitionBlock), transitionBlockHeat, upperBound, lowerBound);
    }

    @Nullable
    public GeothermalConversionRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
        List blocks = PacketUtils.readList((FriendlyByteBuf)buffer, buf -> (Block)buf.readRegistryIdUnsafe(ForgeRegistries.BLOCKS));
        Block baseBlock = (Block)blocks.get(0);
        Block upperBlock = (Block)blocks.get(1);
        Block lowerBlock = (Block)blocks.get(2);
        int transitionBlockHeat = buffer.readInt();
        boolean hasUpper = upperBlock != Blocks.f_50375_;
        boolean hasLower = lowerBlock != Blocks.f_50375_;
        Pair upperBound = null;
        Pair lowerBound = null;
        if (hasUpper) {
            upperBound = Pair.of((Object)upperBlock, (Object)buffer.readInt());
        }
        if (hasLower) {
            lowerBound = Pair.of((Object)lowerBlock, (Object)buffer.readInt());
        }
        return new GeothermalConversionRecipe(resourceLocation, (Lazy<Block>)((Lazy)() -> baseBlock), transitionBlockHeat, (Pair<Block, Integer>)upperBound, (Pair<Block, Integer>)lowerBound);
    }

    public void toNetwork(FriendlyByteBuf buffer, GeothermalConversionRecipe recipe) {
        PacketUtils.writeList((FriendlyByteBuf)buffer, recipe.getMatchingBlocks(), (b, buf) -> buf.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, b));
        buffer.writeInt(recipe.blockHeat);
        if (recipe.upperHeat != null) {
            buffer.writeInt(recipe.upperHeat.intValue());
        }
        if (recipe.lowerHeat != null) {
            buffer.writeInt(recipe.lowerHeat.intValue());
        }
    }
}

