/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.structural;

import com.igteam.immersivegeology.client.menu.ItemSubGroup;
import com.igteam.immersivegeology.common.block.helper.IGBlockType;
import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.MaterialTexture;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class IGFenceBlock
extends FenceBlock
implements IGBlockType {
    protected final Map<MaterialTexture, MaterialInterface<?>> materialMap = new HashMap();
    protected final BlockCategoryFlags category;

    public IGFenceBlock(BlockCategoryFlags flag, MaterialInterface<?> material) {
        this(flag, material, ((GeologyMaterial)material.instance()).getProperties(flag));
    }

    public IGFenceBlock(BlockCategoryFlags flag, MaterialInterface<?> material, BlockBehaviour.Properties props) {
        super(props);
        this.materialMap.put(MaterialTexture.base, material);
        this.category = flag;
    }

    @Override
    public Block getIGBlock() {
        return this;
    }

    @Override
    @NotNull
    public Collection<MaterialInterface<?>> getMaterials() {
        return this.materialMap.values();
    }

    @Override
    public MaterialInterface<?> getMaterial(MaterialTexture t) {
        return this.materialMap.get((Object)t);
    }

    @Override
    public IFlagType<?> getFlag() {
        return this.category;
    }

    @Override
    public ItemSubGroup getGroup() {
        return this.category.getSubGroup();
    }

    @Override
    public Map<MaterialTexture, MaterialInterface<?>> getMaterialMap() {
        return this.materialMap;
    }

    @Override
    public int getColor(int index, BlockState state) {
        return this.materialMap.get((Object)MaterialTexture.values()[index > 0 ? 1 : 0]).getColor(this.category, 0);
    }
}

