/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.event;

import com.igteam.immersivegeology.common.commands.IGFindMineralVeinCommand;
import com.igteam.immersivegeology.common.event.VeinScanTask;
import com.igteam.immersivegeology.common.world.features.IGOreFeature;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.helper.flags.ModFlags;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class IGCommonForgeEvents {
    public static final List<VeinScanTask> activeVeinScans = Collections.synchronizedList(new ArrayList());

    @SubscribeEvent
    public void interruptLootTableLoading(LootTableLoadEvent event) {
        String namespace = event.getName().m_135827_();
        if (!"immersivegeology".equals(namespace)) {
            return;
        }
        String path = event.getName().m_135815_();
        for (ModFlags mods : ModFlags.values()) {
            if (!(path.contains(mods.getName()) & !mods.isLoaded())) continue;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        IGLib.IG_LOGGER.info("Registered Custom Commands");
        CommandDispatcher dispatcher = event.getDispatcher();
        IGFindMineralVeinCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    @SubscribeEvent
    public void updateMapData(TickEvent.LevelTickEvent event) {
        if (event.side.isClient()) {
            return;
        }
        ArrayList<VeinScanTask> toRemove = new ArrayList<VeinScanTask>();
        block0: for (VeinScanTask task : activeVeinScans) {
            if (task.isComplete()) {
                task.source.m_81352_((Component)Component.m_237113_((String)("No " + task.type.getTranslationName() + " ore vein found within " + task.radius + " chunk radius.")));
                toRemove.add(task);
                continue;
            }
            ChunkPos currentChunkPos = task.nextChunk();
            LevelChunk chunk = task.level.m_6325_(currentChunkPos.f_45578_, currentChunkPos.f_45579_);
            int sectionMin = task.level.m_151564_(task.level.m_141937_());
            int sectionMax = task.level.m_151564_(task.level.m_151558_());
            TagKey<Block> materialTag = task.type.getBlockMaterialTag();
            MutableComponent progressMessage = Component.m_237113_((String)("Scanning chunk: [" + currentChunkPos.f_45578_ + ", " + currentChunkPos.f_45579_ + "]")).m_130940_(ChatFormatting.YELLOW);
            task.source.m_230896_().m_5661_((Component)progressMessage, true);
            for (int sectionIndex = sectionMin; sectionIndex < sectionMax; ++sectionIndex) {
                LevelChunkSection section = chunk.m_183278_(sectionIndex);
                if (section.m_188008_() || !section.m_63002_(b -> b.m_204336_(materialTag))) continue;
                BlockPos orePosition = chunk.m_7697_().m_45615_();
                int distance = Mth.m_14143_((float)Mth.m_14116_((float)((float)task.source.m_81371_().m_82531_((double)orePosition.m_123341_(), (double)orePosition.m_123342_(), (double)orePosition.m_123343_()))));
                MutableComponent coordinates = ComponentUtils.m_130748_((Component)Component.m_237110_((String)"chat.coordinates", (Object[])new Object[]{orePosition.m_123341_(), orePosition.m_123342_(), orePosition.m_123343_()})).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + orePosition.m_123341_() + " ~ " + orePosition.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.coordinates.tooltip"))));
                task.source.m_288197_(() -> IGCommonForgeEvents.lambda$updateMapData$2(task, (Component)coordinates, distance), false);
                toRemove.add(task);
                continue block0;
            }
        }
        activeVeinScans.removeAll(toRemove);
    }

    private static void checkAndRenderMap(ItemStack stack, Level level, Player player) {
        if (level == null) {
            return;
        }
        if (level instanceof ServerLevel) {
            Integer mapId;
            MapItemSavedData data;
            ServerLevel serverLevel = (ServerLevel)level;
            if (stack.m_41720_() instanceof MapItem && (data = MapItem.m_151128_((Integer)(mapId = MapItem.m_151131_((ItemStack)stack)), (Level)level)) != null) {
                int scale_mult = 1 + Byte.toUnsignedInt(data.f_77890_);
                int scale = 8 * scale_mult / 2;
                for (int offsetX = -scale; offsetX < scale; ++offsetX) {
                    for (int offsetZ = -scale; offsetZ < scale; ++offsetZ) {
                        byte br = 0;
                        ChunkPos chunkPos = new ChunkPos(data.f_256718_ + offsetX * 16, data.f_256789_ + offsetZ * 16);
                        int z = chunkPos.f_45579_;
                        int x = chunkPos.f_45578_;
                        Holder biomeHolder = serverLevel.m_204166_(chunkPos.m_45615_());
                        if (!IGCommonForgeEvents.isCustomOreFeaturePresent((Holder<Biome>)biomeHolder, chunkPos, serverLevel.m_7328_())) continue;
                        byte bx = (byte)x;
                        byte bz = (byte)z;
                        AtomicBoolean hasInstance = new AtomicBoolean(false);
                        ArrayList<MapDecoration> decorations = new ArrayList<MapDecoration>();
                        data.m_164811_().forEach(d -> {
                            if (d.m_77804_() == bx && d.m_77805_() == bz && d.m_77806_() == br && d.m_77803_() == MapDecoration.Type.RED_X) {
                                hasInstance.set(true);
                            }
                            if (!d.m_77803_().equals((Object)MapDecoration.Type.PLAYER)) {
                                decorations.add((MapDecoration)d);
                            }
                        });
                        if (hasInstance.get()) continue;
                        decorations.add(new MapDecoration(MapDecoration.Type.RED_X, bx, bz, br, (Component)Component.m_237119_()));
                        data.m_164801_(decorations);
                        level.m_142325_(MapItem.m_42848_((int)mapId), data);
                        data.m_77918_(player, stack);
                    }
                }
            }
        }
    }

    private static boolean isCustomOreFeaturePresent(Holder<Biome> biomeHolder, ChunkPos pos, long seed) {
        Biome biome = (Biome)biomeHolder.get();
        List features = biome.m_47536_().m_47818_();
        for (HolderSet featureSet : features) {
            for (Holder featureHolder : featureSet) {
                if (!IGCommonForgeEvents.isCustomOreFeature((PlacedFeature)featureHolder.m_203334_(), pos, biomeHolder, seed)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCustomOreFeature(PlacedFeature placedFeature, ChunkPos pos, Holder<Biome> biome, long seed) {
        ConfiguredFeature feature = (ConfiguredFeature)placedFeature.f_191775_().get();
        return feature.f_65378_() instanceof IGOreFeature.IGOreFeatureConfig;
    }

    private static /* synthetic */ Component lambda$updateMapData$2(VeinScanTask task, Component coordinates, int distance) {
        return Component.m_237110_((String)"command.immersivegeology.veinlocate", (Object[])new Object[]{task.type.getTranslationName(), coordinates, distance});
    }
}

