/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.integration;

import com.igteam.immersivegeology.common.block.multiblocks.recipe.BallmillRecipe;
import com.igteam.immersivegeology.common.integration.IGRecipeCategory;
import com.igteam.immersivegeology.common.integration.JEIRecipeTypes;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.Arrays;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class IGBallmillCategory
extends IGRecipeCategory<BallmillRecipe> {
    public IGBallmillCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.BALLMILL, "block.immersivegeology.ballmill");
        ResourceLocation background = new ResourceLocation("immersivegeology", "textures/gui/jei/ballmill.png");
        IDrawableStatic back = this.guiHelper.drawableBuilder(background, 0, 0, 101, 101).setTextureSize(101, 101).build();
        this.setBackground(back);
        this.setIcon(IGMultiblockProvider.BALLMILL.iconStack());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BallmillRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 33).addItemStacks(Arrays.asList(recipe.itemIn.getMatchingStacks()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 67, 42).addItemStacks(Arrays.asList(recipe.itemOutput.getMatchingStacks()));
    }

    public void draw(BallmillRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        int time = recipe.getTotalProcessTime();
        int timeInSeconds = time / 20;
        int energyPt = recipe.getTotalProcessEnergy() / time;
        guiGraphics.m_280488_(this.font, timeInSeconds + " Seconds", 12, 72, -1);
        guiGraphics.m_280488_(this.font, energyPt + " FE/t", 12, 84, -1);
    }
}

