/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.integration;

import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.CentrifugeRecipe;
import com.igteam.immersivegeology.common.integration.IGRecipeCategory;
import com.igteam.immersivegeology.common.integration.JEIRecipeTypes;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class IGCentrifugeCategory
extends IGRecipeCategory<CentrifugeRecipe> {
    public IGCentrifugeCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.CENTRIFUGE, "block.immersivegeology.centrifuge");
        ResourceLocation background = new ResourceLocation("immersivegeology", "textures/gui/jei/centrifuge.png");
        IDrawableStatic back = this.guiHelper.drawableBuilder(background, 0, 0, 101, 101).setTextureSize(101, 101).build();
        this.setBackground(back);
        this.setIcon(IGMultiblockProvider.CENTRIFUGE.iconStack());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CentrifugeRecipe recipe, IFocusGroup focuses) {
        int tankSize = Math.max(2000, Math.max(recipe.fluidIn.getAmount(), recipe.fluidIn.getAmount()));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 43, 9).setFluidRenderer((long)tankSize, false, 15, 51).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.fluidIn.getMatchingFluidStacks())).addTooltipCallback(JEIHelper.fluidTooltipCallback);
        if (!((FluidStack)recipe.primaryFluidOutput.get()).isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 10, 37).setFluidRenderer(432L, false, 15, 55).addFluidStack(((FluidStack)recipe.primaryFluidOutput.get()).getFluid(), (long)((FluidStack)recipe.primaryFluidOutput.get()).getAmount())).addTooltipCallback(JEIHelper.fluidTooltipCallback);
        }
        if (!((FluidStack)recipe.secondaryFluidOutput.get()).isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 37).setFluidRenderer(432L, false, 15, 55).addFluidStack(((FluidStack)recipe.secondaryFluidOutput.get()).getFluid(), (long)((FluidStack)recipe.secondaryFluidOutput.get()).getAmount())).addTooltipCallback(JEIHelper.fluidTooltipCallback);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 42, 76).addItemStack((ItemStack)recipe.itemOutput.get());
    }

    public void draw(CentrifugeRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        int time = recipe.getTotalProcessTime();
        int timeInSeconds = time / 20;
        int energyPt = recipe.getTotalProcessEnergy() / time;
        guiGraphics.m_280488_(this.font, timeInSeconds + " Seconds", 4, 4, -1);
        guiGraphics.m_280488_(this.font, energyPt + " FE/t", 4, 14, -1);
    }
}

