/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.integration;

import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.common.config.IGServerConfig;
import com.igteam.immersivegeology.common.integration.IGRecipeCategory;
import com.igteam.immersivegeology.common.integration.JEIRecipeTypes;
import com.igteam.immersivegeology.common.recipe.IGGeoRecipe;
import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.enums.StoneEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class IGGeologyCategory
extends IGRecipeCategory<IGGeoRecipe> {
    int tick = 0;
    private final Map<String, String> dimensionNameCache = new HashMap<String, String>();

    public IGGeologyCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.GEOHINT, "block.immersivegeology.geohint");
        ResourceLocation background = new ResourceLocation("minecraft", "textures/gui/light_dirt_background.png");
        IDrawableStatic back = this.guiHelper.drawableBuilder(background, 0, 0, 180, 192).setTextureSize(16, 16).build();
        this.setBackground(back);
        this.setIcon(new ItemStack((ItemLike)MineralEnum.Unobtania.getOreBlock(StoneEnum.MCStone, OreRichness.NORMAL).asIGItem()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IGGeoRecipe recipe, IFocusGroup focuses) {
        GeologyMaterial material = recipe.material;
        ArrayList<ItemStack> triggerInputs = new ArrayList<ItemStack>();
        List<ItemCategoryFlags> ore_types = List.of(ItemCategoryFlags.POOR_ORE, ItemCategoryFlags.NORMAL_ORE, ItemCategoryFlags.RICH_ORE);
        for (ItemCategoryFlags in : ore_types) {
            if (!material.hasFlag(in)) continue;
            triggerInputs.add(material.getStack(in, 1));
        }
        for (StoneEnum stone : StoneEnum.values()) {
            if (!material.acceptableStoneType(stone)) continue;
            if (material.getOreBlock(stone, OreRichness.POOR) != null) {
                triggerInputs.add(new ItemStack((ItemLike)material.getOreBlock(stone, OreRichness.POOR).asIGBlock()));
            }
            if (material.getOreBlock(stone, OreRichness.NORMAL) != null) {
                triggerInputs.add(new ItemStack((ItemLike)material.getOreBlock(stone, OreRichness.NORMAL).asIGBlock()));
            }
            if (material.getOreBlock(stone, OreRichness.RICH) == null) continue;
            triggerInputs.add(new ItemStack((ItemLike)material.getOreBlock(stone, OreRichness.RICH).asIGBlock()));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 4, 18).addItemStacks(triggerInputs)).setBackground((IDrawable)JEIHelper.slotDrawable, -1, -1);
    }

    public void draw(IGGeoRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        ++this.tick;
        GeologyMaterial material = recipe.material;
        String materialName = this.formatMaterialName(material.getName());
        IGServerConfig.Ores.OreConfig config = this.getOreConfig(material, materialName);
        this.drawMaterialName(guiGraphics, materialName);
        this.drawOreInformation(guiGraphics, config, material);
        this.drawFoundInLocations(guiGraphics, config, material);
        this.drawManualReference(guiGraphics);
    }

    private String formatMaterialName(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private IGServerConfig.Ores.OreConfig getOreConfig(GeologyMaterial material, String materialName) {
        boolean isMineral = material instanceof MaterialMineral;
        Enum materialInterface = isMineral ? MineralEnum.valueOf(materialName) : MetalEnum.valueOf(materialName);
        return IGServerConfig.ORES.ores.get(materialInterface.getConfig());
    }

    private void drawMaterialName(GuiGraphics guiGraphics, String materialName) {
        guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, materialName, 4, 4, -1);
    }

    private void drawOreInformation(GuiGraphics guiGraphics, IGServerConfig.Ores.OreConfig config, GeologyMaterial material) {
        String[] infoLines;
        int INFO_X = 4;
        int INFO_Y_BASE = 60;
        int LINE_HEIGHT = 12;
        int TEXT_COLOR = -1;
        Font font = Minecraft.m_91087_().f_91062_;
        int currentY = 60;
        double noise_probability = material.getNoiseProbability();
        double chunk_probability = (double)((Integer)config.generationChance.get()).intValue() / 2000000.0;
        double finalProb = noise_probability * chunk_probability;
        DecimalFormat format = new DecimalFormat("0.####");
        for (String line : infoLines = new String[]{"Enabled: " + String.valueOf(config.canSpawn.get()), "Y Range: " + String.valueOf(config.minY.get()) + " ~ " + String.valueOf(config.maxY.get()), "Temp Range: " + String.valueOf(config.min_temp.get()) + " ~ " + String.valueOf(config.max_temp.get()), "Downfall Range: " + String.valueOf(config.min_downfall.get()) + " ~ " + String.valueOf(config.max_downfall.get()), "Chunk Spawn probability: " + format.format(finalProb * 100.0) + "%"}) {
            guiGraphics.m_280488_(font, line, 4, currentY += 12, -1);
        }
    }

    private void drawFoundInLocations(GuiGraphics guiGraphics, IGServerConfig.Ores.OreConfig config, GeologyMaterial material) {
        int LOCATION_X = 4;
        int LOCATION_Y_BASE = 48;
        int LINE_HEIGHT = 12;
        int TEXT_COLOR = -1;
        Font font = Minecraft.m_91087_().f_91062_;
        guiGraphics.m_280488_(font, "Found in:", 4, 48, -1);
        String[] availableDimensions = this.getAvailableDimensions(config, material);
        if (availableDimensions.length > 0) {
            int dimensionIndex = this.tick / 60 % availableDimensions.length;
            if (dimensionIndex == 0 && this.tick > 256) {
                this.tick = 0;
            }
            int yPos = 60;
            guiGraphics.m_280488_(font, availableDimensions[dimensionIndex], 4, yPos, -1);
        }
    }

    private String[] getAvailableDimensions(IGServerConfig.Ores.OreConfig config, GeologyMaterial material) {
        ArrayList<String> dimensions = new ArrayList<String>();
        List dimension_id = (List)config.dimension_whitelist.get();
        for (String id : dimension_id) {
            dimensions.add(this.formatDimensionID(id));
        }
        return dimensions.toArray(new String[0]);
    }

    private String formatDimensionID(String dimensionId) {
        return this.dimensionNameCache.computeIfAbsent(dimensionId, this::computeDimensionName);
    }

    private String computeDimensionName(String dimensionId) {
        String name = dimensionId.contains(":") ? dimensionId.substring(dimensionId.indexOf(":") + 1) : dimensionId;
        return Arrays.stream(name.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    private void drawManualReference(GuiGraphics guiGraphics) {
        float SCALE = 0.75f;
        int TEXT_COLOR = -1;
        Font font = Minecraft.m_91087_().f_91062_;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(32.0f, 18.0f, 0.0f);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(0.75f, 0.75f, 0.75f);
        guiGraphics.m_280430_(font, (Component)Component.m_237113_((String)"See more in the Geology"), 0, 0, -1);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_252880_(0.0f, 8.0f, 0.0f);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(0.75f, 0.75f, 0.75f);
        guiGraphics.m_280430_(font, (Component)Component.m_237113_((String)"Section of the IE Manual"), 0, 0, -1);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85849_();
    }
}

