/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.integration;

import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.PelletizerRecipe;
import com.igteam.immersivegeology.common.integration.IGRecipeCategory;
import com.igteam.immersivegeology.common.integration.JEIRecipeTypes;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.Arrays;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class IGPelletizerCategory
extends IGRecipeCategory<PelletizerRecipe> {
    public IGPelletizerCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.PELLETIZER, "block.immersivegeology.pelletizer");
        ResourceLocation background = new ResourceLocation("immersivegeology", "textures/gui/jei/pelletizer.png");
        IDrawableStatic back = this.guiHelper.drawableBuilder(background, 0, 0, 101, 101).setTextureSize(101, 101).build();
        this.setBackground(back);
        this.setIcon(IGMultiblockProvider.PELLETIZER.iconStack());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PelletizerRecipe recipe, IFocusGroup focuses) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        builder.addSlot(RecipeIngredientRole.INPUT, 35, 40).addItemStacks(Arrays.asList(recipe.itemIn.getMatchingStacks()));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 11, 23).setFluidRenderer(500L, false, 16, 55).addFluidStack(ChemicalEnum.BindingAgent.getFluid(BlockCategoryFlags.FLUID), 500L)).addTooltipCallback(JEIHelper.fluidTooltipCallback);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 71, 62).addItemStack((ItemStack)recipe.itemOutput.get());
    }

    public void draw(PelletizerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        int time = recipe.getTotalProcessTime();
        int timeInSeconds = time / 20;
        int energyPt = recipe.getTotalProcessEnergy() / time;
        guiGraphics.m_280488_(this.font, timeInSeconds + " Seconds", 32, 8, -1);
        guiGraphics.m_280488_(this.font, energyPt + " FE/t", 32, 18, -1);
    }
}

