/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.integration;

import com.igteam.immersivegeology.common.block.multiblocks.recipe.RotaryKilnRecipe;
import com.igteam.immersivegeology.common.integration.IGRecipeCategory;
import com.igteam.immersivegeology.common.integration.JEIRecipeTypes;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.Arrays;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class IGRotaryKilnCategory
extends IGRecipeCategory<RotaryKilnRecipe> {
    public IGRotaryKilnCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.ROTARYKILN, "block.immersivegeology.rotary_kiln");
        ResourceLocation background = new ResourceLocation("immersivegeology", "textures/gui/jei/rotary_kiln.png");
        IDrawableStatic back = this.guiHelper.drawableBuilder(background, 0, 0, 101, 101).setTextureSize(101, 101).build();
        this.setBackground(back);
        this.setIcon(IGMultiblockProvider.ROTARYKILN.iconStack());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RotaryKilnRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 33).addItemStacks(Arrays.asList(recipe.itemIn.getMatchingStacks()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 67, 42).addItemStack((ItemStack)recipe.itemOutput.get());
    }

    public void draw(RotaryKilnRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        int time = recipe.getTotalProcessTime();
        int timeInSeconds = time / 20;
        guiGraphics.m_280488_(this.font, timeInSeconds + " Seconds", 7, 58, -1);
        guiGraphics.m_280488_(this.font, this.translateHeat(recipe.getHeatRequired()), 7, 72, -1);
    }

    private String translateHeat(int heatRequired) {
        String lv = Component.m_237115_((String)"manual.immersivegeology.lv_heat").getString();
        String mv = Component.m_237115_((String)"manual.immersivegeology.mv_heat").getString();
        String hv = Component.m_237115_((String)"manual.immersivegeology.hv_heat").getString();
        String ehv = Component.m_237115_((String)"manual.immersivegeology.ehv_heat").getString();
        return heatRequired == 30 ? lv : (heatRequired == 75 ? mv : (heatRequired == 120 ? hv : ehv));
    }
}

