/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.item;

import com.igteam.immersivegeology.client.menu.ItemSubGroup;
import com.igteam.immersivegeology.common.block.helper.IGBlockType;
import com.igteam.immersivegeology.common.block.helper.IOreBlock;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.common.item.helper.IGFlagItem;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.MaterialTexture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IGGenericBlockItem
extends BlockItem
implements IGFlagItem {
    private final IGBlockType block;

    public IGGenericBlockItem(IGBlockType block) {
        this(block, new Item.Properties());
    }

    public IGGenericBlockItem(IGBlockType block, Item.Properties properties) {
        super(block.getIGBlock(), properties);
        this.block = block;
    }

    @Override
    public IFlagType<?> getFlag() {
        return this.block.getFlag();
    }

    @Override
    public ItemSubGroup getSubGroup() {
        return this.block.getGroup();
    }

    @Override
    public Collection<MaterialInterface<?>> getMaterials() {
        return this.block.getMaterials();
    }

    @Override
    public MaterialInterface<?> getMaterial(MaterialTexture t) {
        return this.block.getMaterial(t);
    }

    @Override
    public int getColor(int index) {
        return this.block.getColor(index > 0 ? 1 : 0, this.block.getIGBlock().m_49966_());
    }

    protected boolean m_7429_(@NotNull BlockPlaceContext context, @NotNull BlockState state) {
        Block b = state.m_60734_();
        return super.m_7429_(context, state);
    }

    @NotNull
    public Component m_7626_(ItemStack pStack) {
        Map<MaterialTexture, MaterialInterface<?>> materialMap = this.block.getMaterialMap();
        ArrayList<String> materialList = new ArrayList<String>();
        BlockCategoryFlags flag = (BlockCategoryFlags)this.getFlag();
        switch (flag) {
            case ORE_BLOCK: {
                Block block = this.m_40614_();
                if (!(block instanceof IOreBlock)) break;
                IOreBlock oreBlock = (IOreBlock)block;
                MutableComponent normalName = Component.m_237115_((String)("material.immersivegeology.ore." + oreBlock.getOreRichness().name().toLowerCase()));
                if (!oreBlock.getOreRichness().equals((Object)OreRichness.NORMAL)) {
                    normalName.m_7220_((Component)Component.m_237115_((String)"formatting.space"));
                }
                normalName.m_7220_((Component)Component.m_237115_((String)("material.immersivegeology." + materialMap.get((Object)MaterialTexture.base).getName())));
                normalName.m_7220_((Component)Component.m_237115_((String)"formatting.space"));
                normalName.m_7220_((Component)Component.m_237115_((String)("material.immersivegeology." + materialMap.get((Object)MaterialTexture.overlay).getName())));
                return normalName;
            }
            case ENGINEERING_BLOCK: {
                materialList.add(Component.m_237115_((String)("material.immersivegeology.engineering." + materialMap.get((Object)MaterialTexture.base).getName())).getString());
                break;
            }
            case ADVANCED_ENGINEERING_BLOCK: {
                materialList.add(Component.m_237115_((String)("material.immersivegeology.adv_engineering." + materialMap.get((Object)MaterialTexture.base).getName())).getString());
                break;
            }
            default: {
                for (MaterialTexture t : MaterialTexture.values()) {
                    if (!materialMap.containsKey((Object)t)) continue;
                    materialList.add(Component.m_237115_((String)("material.immersivegeology." + materialMap.get((Object)t).getName())).getString());
                }
            }
        }
        return Component.m_237110_((String)("block.immersivegeology." + this.block.getFlag().getName()), (Object[])materialList.toArray());
    }

    public boolean cancelDatagen() {
        if (this.block.getMaterials().isEmpty()) {
            IGLib.IG_LOGGER.warn("Block for Item has no Material (Are we using a pre defined model?) [{}]", (Object)this.m_5524_());
        }
        return this.block.getMaterials().isEmpty();
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        MaterialInterface<?> base = this.getMaterial(MaterialTexture.base);
        if (base.hasBurnTime()) {
            return base.getBurnTime() * 2 * 10;
        }
        return super.getBurnTime(itemStack, recipeType);
    }
}

