/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.item;

import com.igteam.immersivegeology.client.menu.ItemSubGroup;
import com.igteam.immersivegeology.common.item.helper.IGFlagItem;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.MaterialTexture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IGGenericItem
extends Item
implements IGFlagItem {
    protected final Map<MaterialTexture, MaterialInterface<?>> materialMap = new HashMap();
    protected final ItemCategoryFlags category;
    protected String customLang = "";
    boolean hasCustomLang = false;

    public IGGenericItem(ItemCategoryFlags flag, MaterialInterface<?> material) {
        this(flag, material, new Item.Properties());
    }

    public IGGenericItem(ItemCategoryFlags flag, MaterialInterface<?> material, Item.Properties properties) {
        super(properties);
        this.materialMap.put(MaterialTexture.base, material);
        this.category = flag;
    }

    @Override
    public int getColor(int index) {
        if (this.getFlag().hasPalette() || this.getFlag().equals(ItemCategoryFlags.PELLET) || this.getFlag().equals(ItemCategoryFlags.OXIDE_PELLET) || this.getFlag().equals(ItemCategoryFlags.HAMMER) || this.getMaxStackSize(this.m_7968_()) == 1) {
            return 0xFFFFFF;
        }
        if (index >= this.materialMap.values().size()) {
            index %= this.materialMap.values().size();
        }
        return this.materialMap.get((Object)MaterialTexture.values()[index]).getColor(this.category, 0);
    }

    public boolean isIGRepairable(ItemStack stack) {
        return false;
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        MaterialInterface<?> base = this.getMaterial(MaterialTexture.base);
        if (base.hasBurnTime()) {
            return base.getBurnTime();
        }
        return super.getBurnTime(itemStack, recipeType);
    }

    @NotNull
    public Component m_7626_(ItemStack stack) {
        if (this.hasCustomLang) {
            return Component.m_237115_((String)("item.immersivegeology." + this.customLang)).m_130940_(this.getMaterial((MaterialTexture)MaterialTexture.base).getRarity().f_43022_);
        }
        ArrayList<String> materialList = new ArrayList<String>();
        for (MaterialTexture t : MaterialTexture.values()) {
            if (!this.materialMap.containsKey((Object)t)) continue;
            materialList.add(Component.m_237115_((String)("material.immersivegeology." + this.materialMap.get((Object)t).getName())).getString());
        }
        return Component.m_237110_((String)("item.immersivegeology." + this.category.getName()), (Object[])materialList.toArray()).m_130940_(this.getMaterial((MaterialTexture)MaterialTexture.base).getRarity().f_43022_);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        MaterialInterface<?> materialInterface;
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        if (this.getFlag().equals(ItemCategoryFlags.INGOT) && (materialInterface = this.getMaterial(MaterialTexture.base)) instanceof MetalEnum) {
            MetalEnum metal = (MetalEnum)materialInterface;
            pTooltipComponents.add((Component)Component.m_237115_((String)"immersivegeology.item.text.sources"));
            Set<MaterialHelper> sources = metal.getOriginMaterials();
            for (MaterialHelper source : sources) {
                pTooltipComponents.add((Component)Component.m_237115_((String)("material.immersivegeology." + source.getName())).m_130940_(ChatFormatting.GOLD));
            }
        }
    }

    public ItemCategoryFlags getFlag() {
        return this.category;
    }

    @Override
    public ItemSubGroup getSubGroup() {
        return this.category.getSubGroup();
    }

    @Override
    public Collection<MaterialInterface<?>> getMaterials() {
        return this.materialMap.values();
    }

    @Override
    public MaterialInterface<?> getMaterial(MaterialTexture t) {
        return this.materialMap.get((Object)t);
    }

    public Item setCustomLangString(String rawRefractoryBrick) {
        this.hasCustomLang = true;
        this.customLang = rawRefractoryBrick;
        return this;
    }
}

