/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.item;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.multiblocks.BlockMatcher;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.advancements.IEAdvancements;
import com.google.common.collect.ImmutableList;
import com.igteam.immersivegeology.common.block.multiblocks.IGTemplateMultiblock;
import com.igteam.immersivegeology.common.item.IGGenericItem;
import com.igteam.immersivegeology.core.material.data.enums.StoneEnum;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.MaterialTexture;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.Tags;

public class IGMBFormationItem
extends IGGenericItem {
    BiPredicate<MultiblockHandler.IMultiblock, MaterialInterface<?>> validPredicate = (multiblock, material) -> material.canFormMB((MultiblockHandler.IMultiblock)multiblock);

    public IGMBFormationItem(ItemCategoryFlags flag, MaterialInterface<?> material2, int max_durability) {
        super(flag, material2, new Item.Properties().m_41499_(max_durability));
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    @Override
    public Component m_7626_(ItemStack pStack) {
        return Component.m_237115_((String)this.m_5671_(pStack));
    }

    @Override
    public int getColor(int index) {
        return 0xFFFFFF;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        ListTag list;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        Direction side = context.m_43719_();
        List<ResourceLocation> permittedMultiblocks = null;
        List<ResourceLocation> interdictedMultiblocks = null;
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblockPermission") && (permittedMultiblocks = IGMBFormationItem.parseMultiblockNames(list = stack.m_41784_().m_128437_("multiblockPermission", 8), player, "permission")) == null) {
            return InteractionResult.FAIL;
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblockInterdiction") && (interdictedMultiblocks = IGMBFormationItem.parseMultiblockNames(list = stack.m_41784_().m_128437_("multiblockInterdiction", 8), player, "interdiction")) == null) {
            return InteractionResult.FAIL;
        }
        Direction multiblockSide = side.m_122434_() == Direction.Axis.Y && player != null ? Direction.m_122364_((double)player.m_146908_()).m_122424_() : side;
        for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
            boolean isAllowed;
            boolean isValid = this.validPredicate.test(mb, this.getMaterial(MaterialTexture.base));
            boolean isBlockTrigger = mb.isBlockTrigger(world.m_8055_(pos), multiblockSide, world);
            if (!isBlockTrigger || !(isAllowed = permittedMultiblocks != null ? permittedMultiblocks.contains(mb.getUniqueName()) : (interdictedMultiblocks != null ? !interdictedMultiblocks.contains(mb.getUniqueName()) : true)) || MultiblockHandler.postMultiblockFormationEvent((Player)player, (MultiblockHandler.IMultiblock)mb, (BlockPos)pos, (ItemStack)stack).isCanceled()) continue;
            if (isValid) {
                if (!mb.createStructure(world, pos, multiblockSide, player)) continue;
                if (player instanceof ServerPlayer) {
                    ServerPlayer sPlayer = (ServerPlayer)player;
                    IEAdvancements.TRIGGER_MULTIBLOCK.trigger(sPlayer, mb, stack);
                }
                stack.m_41622_(1, (LivingEntity)player, p -> {});
                return InteractionResult.SUCCESS;
            }
            if (player == null || !IGMBFormationItem.confirmMBStructure((TemplateMultiblock)mb, world, pos, side, player)) continue;
            player.m_5661_((Component)Component.m_237115_((String)"immersivegeology.multiblock.formation.failed"), true);
        }
        return InteractionResult.PASS;
    }

    public static boolean confirmMBStructure(TemplateMultiblock mb, Level world, BlockPos pos, Direction side, Player player) {
        Rotation rot = DirectionUtils.getRotationBetweenFacings((Direction)Direction.NORTH, (Direction)side.m_122424_());
        if (rot == null) {
            return false;
        }
        List structure = mb.getStructure(world);
        ImmutableList mirror_states = mb.canBeMirrored() ? ImmutableList.of((Object)Mirror.NONE, (Object)Mirror.FRONT_BACK) : ImmutableList.of((Object)Mirror.NONE);
        block0: for (Mirror mirror : mirror_states) {
            StructurePlaceSettings placeSet = new StructurePlaceSettings().m_74377_(mirror).m_74379_(rot);
            BlockPos origin = pos.m_121996_((Vec3i)StructureTemplate.m_74563_((StructurePlaceSettings)placeSet, (BlockPos)mb.getTriggerOffset()));
            for (StructureTemplate.StructureBlockInfo info : structure) {
                BlockState inWorld;
                BlockPos realRelPos = StructureTemplate.m_74563_((StructurePlaceSettings)placeSet, (BlockPos)info.f_74675_());
                BlockPos here = origin.m_121955_((Vec3i)realRelPos);
                BlockState expected = info.f_74676_().m_60715_(mirror).m_60717_(rot);
                if (BlockMatcher.matches((BlockState)expected, (BlockState)(inWorld = world.m_8055_(here)), (Level)world, (BlockPos)here).isAllow()) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static List<ResourceLocation> parseMultiblockNames(ListTag data, @Nullable Player player, String prefix) {
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        for (int i = 0; i < data.size(); ++i) {
            String listEntry = data.m_128778_(i);
            ResourceLocation asRL = ResourceLocation.m_135820_((String)listEntry);
            if (asRL == null || MultiblockHandler.getByUniqueName((ResourceLocation)asRL) == null) {
                if (player != null && !player.m_20193_().f_46443_) {
                    player.m_5661_((Component)Component.m_237113_((String)("Invalid " + prefix + " entry: " + listEntry)), false);
                }
                return null;
            }
            result.add(asRL);
        }
        return result;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44986_ || enchantment == Enchantments.f_44962_;
    }

    @Override
    public boolean isIGRepairable(ItemStack stack) {
        return true;
    }

    @Nonnull
    public ItemStack getCraftingRemainingItem(@Nonnull ItemStack stack) {
        ItemStack container = stack.m_41777_();
        return container.m_220157_(1, ApiUtils.RANDOM_SOURCE, (ServerPlayer)null) ? ItemStack.f_41583_ : container;
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairCandidate) {
        if (this.materialMap.get((Object)MaterialTexture.base) instanceof StoneEnum) {
            return repairCandidate.m_204117_(Tags.Items.COBBLESTONE);
        }
        return repairCandidate.m_150930_(((MaterialInterface)this.materialMap.get((Object)MaterialTexture.base)).getItem(ItemCategoryFlags.INGOT));
    }

    public boolean canFormMB(MaterialInterface<?> material, IGTemplateMultiblock igTemplateMultiblock) {
        return this.validPredicate.test((MultiblockHandler.IMultiblock)igTemplateMultiblock, material);
    }
}

