/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.network.msg;

import blusunrize.immersiveengineering.common.network.IMessage;
import com.igteam.immersivegeology.core.material.data.enums.MiscEnum;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageSCRFail
implements IMessage {
    private final BlockPos pos;
    private final float damage;

    public MessageSCRFail(BlockPos pos, float damage) {
        this.pos = pos;
        this.damage = damage;
    }

    public MessageSCRFail(FriendlyByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.damage = buf.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.pos.m_123341_()).writeInt(this.pos.m_123342_()).writeInt(this.pos.m_123343_());
        buf.writeFloat(this.damage);
    }

    public void process(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        if (ctx.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            ctx.enqueueWork(() -> {
                ServerLevel world = Objects.requireNonNull(ctx.getSender()).m_284548_();
                if (world.isAreaLoaded(this.pos, 1)) {
                    BlockState blockState = world.m_8055_(this.pos);
                    BlockPos.MutableBlockPos b = new BlockPos.MutableBlockPos();
                    b.m_122190_((Vec3i)this.pos);
                    RandomSource random = world.m_213780_();
                    for (int x = 0; x <= 1; ++x) {
                        for (int z = 0; z <= 1; ++z) {
                            for (int y = 0; y < 4; ++y) {
                                if (!((float)random.m_216339_(1, 95) < this.damage)) continue;
                                BlockPos pos = b.m_7918_(x, y, z);
                                BlockState newState = MiscEnum.RustyMetal.getBlock(BlockCategoryFlags.SHEETMETAL_BLOCK).m_49966_();
                                world.m_7731_(pos, newState, 3);
                            }
                        }
                    }
                }
            });
        }
    }
}

