/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.particle.types;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlowingWaterParticle
extends TextureSheetParticle {
    private static final float GRAVITY = 0.04f;
    private static final float FRICTION = 0.97f;
    private static final float DAMPENING = 0.5f;
    private static final float SENSOR_DISTANCE = 0.05f;
    private static final float AVOID_FORCE = 0.03f;
    private static final float VISCOSITY = 0.97f;

    public FlowingWaterParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        this.m_107250_(0.01f, 0.01f);
        this.f_107663_ = this.f_107223_.m_188501_() * 0.05f;
        this.f_107225_ = 20 + this.f_107223_.m_188503_(20);
        this.f_107226_ = 0.04f;
        float blueIntensity = 0.7f + this.f_107223_.m_188501_() * 0.3f;
        this.f_107227_ = 0.2f * blueIntensity;
        this.f_107228_ = 0.4f * blueIntensity;
        this.f_107229_ = 0.8f * blueIntensity;
        this.f_107230_ = 0.7f + this.f_107223_.m_188501_() * 0.3f;
        this.f_107219_ = false;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        this.f_107216_ -= (double)this.f_107226_;
        double nextX = this.f_107212_ + this.f_107215_;
        double nextY = this.f_107213_ + this.f_107216_;
        double nextZ = this.f_107214_ + this.f_107217_;
        if (this.wouldCollide(nextX, nextY, nextZ)) {
            boolean xCollision = this.wouldCollide(nextX, this.f_107213_, this.f_107214_);
            boolean yCollision = this.wouldCollide(this.f_107212_, nextY, this.f_107214_);
            boolean zCollision = this.wouldCollide(this.f_107212_, this.f_107213_, nextZ);
            if (xCollision) {
                this.f_107215_ *= -0.5;
            }
            if (yCollision) {
                this.f_107216_ *= -0.15;
            }
            if (zCollision) {
                this.f_107217_ *= -0.5;
            }
            if (yCollision) {
                this.f_107215_ += (double)((this.f_107223_.m_188501_() - 0.5f) * 0.02f);
                this.f_107217_ += (double)((this.f_107223_.m_188501_() - 0.5f) * 0.02f);
            }
            this.f_107212_ += this.f_107215_;
            this.f_107213_ += this.f_107216_;
            this.f_107214_ += this.f_107217_;
        } else {
            this.f_107212_ = nextX;
            this.f_107213_ = nextY;
            this.f_107214_ = nextZ;
        }
        this.f_107215_ *= (double)0.97f;
        this.f_107216_ *= (double)0.9409f;
        this.f_107217_ *= (double)0.97f;
        this.updateColor();
        this.updateRoll();
        if (this.isInsideBlock()) {
            this.f_107213_ += (double)0.01f;
            this.f_107216_ = Math.abs(this.f_107216_) * 0.5;
        }
    }

    private void updateColor() {
        float blueIntensity = 0.7f + this.f_107223_.m_188501_() * 0.3f;
        float baseRed = 0.2f * blueIntensity;
        float baseGreen = 0.4f * blueIntensity;
        float baseBlue = 0.8f * blueIntensity;
        float speed = (float)Math.sqrt(this.f_107215_ * this.f_107215_ + this.f_107216_ * this.f_107216_ + this.f_107217_ * this.f_107217_);
        if (this.f_107216_ > (double)0.02f) {
            float whiteFactor = (float)Math.min(1.0, this.f_107216_ * 5.0);
            this.f_107227_ = Mth.m_14179_((float)whiteFactor, (float)baseRed, (float)0.9f);
            this.f_107228_ = Mth.m_14179_((float)whiteFactor, (float)baseGreen, (float)0.9f);
            this.f_107229_ = Mth.m_14179_((float)whiteFactor, (float)baseBlue, (float)1.0f);
        } else if (speed > 0.1f) {
            float whiteFactor = Math.min(0.5f, speed);
            this.f_107227_ = Mth.m_14179_((float)whiteFactor, (float)baseRed, (float)0.6f);
            this.f_107228_ = Mth.m_14179_((float)whiteFactor, (float)baseGreen, (float)0.7f);
            this.f_107229_ = Mth.m_14179_((float)whiteFactor, (float)baseBlue, (float)0.9f);
        } else {
            this.f_107227_ = baseRed;
            this.f_107228_ = baseGreen;
            this.f_107229_ = baseBlue;
        }
        if ((float)this.f_107224_ > (float)this.f_107225_ * 0.8f) {
            this.f_107230_ = 1.0f - ((float)this.f_107224_ - (float)this.f_107225_ * 0.8f) / ((float)this.f_107225_ * 0.2f);
        }
    }

    private boolean isInsideBlock() {
        BlockPos pos = new BlockPos(Mth.m_14107_((double)this.f_107212_), Mth.m_14107_((double)this.f_107213_), Mth.m_14107_((double)this.f_107214_));
        BlockState blockState = this.f_107208_.m_8055_(pos);
        VoxelShape shape = blockState.m_60812_((BlockGetter)this.f_107208_, pos);
        if (shape.m_83281_()) {
            return false;
        }
        AABB particleAABB = new AABB(this.f_107212_ - 0.01, this.f_107213_ - 0.01, this.f_107214_ - 0.01, this.f_107212_ + 0.01, this.f_107213_ + 0.01, this.f_107214_ + 0.01);
        for (AABB aabb : shape.m_83299_()) {
            AABB worldAABB = aabb.m_82386_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            if (!particleAABB.m_82381_(worldAABB)) continue;
            return true;
        }
        return false;
    }

    private boolean wouldCollide(double x, double y, double z) {
        BlockPos blockPos = new BlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
        BlockState blockState = this.f_107208_.m_8055_(blockPos);
        VoxelShape collisionShape = blockState.m_60812_((BlockGetter)this.f_107208_, blockPos);
        if (collisionShape.m_83281_()) {
            return false;
        }
        AABB particleAABB = new AABB(x - 0.01, y - 0.01, z - 0.01, x + 0.01, y + 0.01, z + 0.01);
        for (AABB aabb : collisionShape.m_83299_()) {
            AABB worldAABB = aabb.m_82386_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
            if (!particleAABB.m_82381_(worldAABB)) continue;
            return true;
        }
        return false;
    }

    private void updateRoll() {
        float dx = (float)(this.f_107212_ - this.f_107209_);
        float dz = (float)(this.f_107214_ - this.f_107211_);
        if (dx != 0.0f || dz != 0.0f) {
            this.f_107231_ = (float)Math.atan2(dz, dx);
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }
}

