/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.recipe;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.gson.JsonObject;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.common.recipe.IGGeoRecipe;
import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.enums.StoneEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public class IGGeoSerializer
extends IERecipeSerializer<IGGeoRecipe> {
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)MineralEnum.Unobtania.getOreBlock(StoneEnum.MCStone, OreRichness.NORMAL).asIGBlock());
    }

    public IGGeoRecipe readFromJson(ResourceLocation resourceLocation, JsonObject json, ICondition.IContext iContext) {
        MaterialMineral material;
        int material_index = GsonHelper.m_13927_((JsonObject)json, (String)"material_index");
        int material_type = GsonHelper.m_13927_((JsonObject)json, (String)"material_type");
        switch (material_type) {
            case 0: {
                GeologyMaterial geologyMaterial = MineralEnum.values()[material_index].instance();
                break;
            }
            case 1: {
                GeologyMaterial geologyMaterial = MetalEnum.values()[material_index].instance();
                break;
            }
            default: {
                GeologyMaterial geologyMaterial = material = null;
            }
        }
        if (material == null) {
            throw new IllegalArgumentException();
        }
        return new IGGeoRecipe(resourceLocation, material);
    }

    @Nullable
    public IGGeoRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
        int type = buffer.readInt();
        int index = buffer.readInt();
        GeologyMaterial material = type == 1 ? MetalEnum.values()[index].instance() : MineralEnum.values()[index].instance();
        return new IGGeoRecipe(resourceLocation, material);
    }

    public void toNetwork(FriendlyByteBuf buffer, IGGeoRecipe recipe) {
        GeologyMaterial material = recipe.material;
        int type = material instanceof MaterialMineral ? 0 : 1;
        Object input = material.getName();
        input = ((String)input).substring(0, 1).toUpperCase() + ((String)input).substring(1);
        int index = type == 1 ? MetalEnum.valueOf((String)input).ordinal() : MineralEnum.valueOf((String)input).ordinal();
        buffer.writeInt(type);
        buffer.writeInt(index);
    }
}

