/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.world;

import com.igteam.immersivegeology.common.config.IGServerConfig;
import com.igteam.immersivegeology.common.world.IGWorldGen;
import com.igteam.immersivegeology.common.world.IWorldGenConfig;
import com.igteam.immersivegeology.common.world.features.IGOreFeature;
import com.igteam.immersivegeology.common.world.features.helper.IGOreGenUtils;
import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.data.enums.StoneEnum;
import com.mojang.serialization.Codec;
import java.awt.Graphics2D;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.jetbrains.annotations.Nullable;

public class IGDefaultPlacement
extends PlacementFilter {
    public static final Codec<IGDefaultPlacement> PLACEMENT_CODEC = IWorldGenConfig.CODEC.xmap(IGDefaultPlacement::new, p -> p.entry);
    private final IWorldGenConfig entry;

    public IGDefaultPlacement(IWorldGenConfig entry) {
        this.entry = entry;
    }

    public boolean canPlaceVein(ChunkPos pos, long level_seed, IGServerConfig.Ores.OreConfig config) {
        if ((Integer)config.veinSize.get() <= 0) {
            return false;
        }
        int chance_max = 1000000;
        RandomSource random = IGOreGenUtils.getReuseRandom(this.entry, level_seed, pos);
        return random.m_188503_(chance_max) < (Integer)config.generationChance.get();
    }

    public boolean canPlaceVeinEnd(ChunkPos pos, long level_seed, IGServerConfig.Ores.OreConfig config) {
        if ((Integer)config.veinSize.get() <= 0) {
            return false;
        }
        int chance_max = 750000;
        RandomSource random = IGOreGenUtils.getReuseRandom(this.entry, level_seed, pos);
        return random.m_188503_(chance_max) < (Integer)config.generationChance.get();
    }

    public boolean canSpawnAt(Holder<Biome> biome) {
        float biomeTemp = ((Biome)biome.m_203334_()).m_47554_();
        float biomeDownfall = ((Biome)biome.m_203334_()).getModifiedClimateSettings().f_47683_();
        IGServerConfig.Ores.OreConfig config = IGServerConfig.ORES.ores.get(this.entry);
        if (config == null) {
            IGServerConfig.Evaporates.EvaporateConfig econfig = IGServerConfig.EVAPORITES.evaporates.get(this.entry);
            return (Integer)econfig.veinsPerChunk.get() > 0;
        }
        if (!((Boolean)config.canSpawn.get()).booleanValue()) {
            return false;
        }
        return (double)biomeTemp >= (Double)config.min_temp.get() && (double)biomeTemp <= (Double)config.max_temp.get() && (double)biomeDownfall >= (Double)config.min_downfall.get() && (double)biomeDownfall <= (Double)config.max_downfall.get();
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)IGWorldGen.IG_DEFAULT_PLACEMENT.get();
    }

    public boolean exposedPlace(long seed, WorldGenLevel level, ChunkPos chunkPos, @Nullable Graphics2D g2d) {
        BlockPos worldPos = chunkPos.m_45615_();
        IGServerConfig.Ores.OreConfig config = IGServerConfig.ORES.ores.get(this.entry);
        if (config == null) {
            return true;
        }
        Holder biome = level.m_204166_(worldPos);
        boolean isOverworld = biome.containsTag(BiomeTags.f_215817_);
        boolean isEnd = biome.containsTag(BiomeTags.f_215818_);
        boolean isNether = biome.containsTag(BiomeTags.f_207612_);
        if (isOverworld || isNether || isEnd) {
            boolean possiblePlace;
            boolean bl = (isEnd ? this.canPlaceVeinEnd(chunkPos, seed, config) : this.canPlaceVein(chunkPos, seed, config)) && this.canSpawnAt((Holder<Biome>)biome) ? true : (possiblePlace = false);
            if (!possiblePlace) {
                return false;
            }
            GeologyMaterial material = this.entry.instance();
            boolean canSpawnOverworld = material.acceptableStoneType(StoneEnum.MCStone);
            boolean canSpawnNether = material.acceptableStoneType(StoneEnum.MCNetherrack);
            boolean canSpawnEnd = material.acceptableStoneType(StoneEnum.MCEndStone);
            RandomSource random = IGOreGenUtils.getReuseRandom(this.entry, level.m_7328_(), chunkPos);
            IGOreFeature.Vein vein = IGOreFeature.createVein(random, config, this.entry);
            if (canSpawnOverworld && isOverworld || canSpawnNether && isNether || canSpawnEnd && isEnd) {
                int maxY = (Integer)config.maxY.get();
                int minY = (Integer)config.minY.get();
                return IGOreGenUtils.isVeinWorthwhile((LevelAccessor)level, chunkPos, maxY, minY, vein);
            }
        } else {
            boolean possiblePlace;
            boolean bl = possiblePlace = this.canPlaceVein(chunkPos, seed, config) && this.canSpawnAt((Holder<Biome>)biome);
            if (!possiblePlace) {
                return false;
            }
            RandomSource random = IGOreGenUtils.getReuseRandom(this.entry, level.m_7328_(), chunkPos);
            IGOreFeature.Vein vein = IGOreFeature.createVein(random, config, this.entry);
            int maxY = (Integer)config.maxY.get();
            int minY = (Integer)config.minY.get();
            return IGOreGenUtils.isVeinWorthwhile((LevelAccessor)level, chunkPos, maxY, minY, vein);
        }
        return false;
    }

    protected boolean m_213917_(PlacementContext ctx, RandomSource rnd, BlockPos pos) {
        WorldGenLevel level = ctx.m_191831_();
        ServerLevel serverLevel = level.m_6018_();
        ResourceKey dimensionKey = serverLevel.m_46472_();
        ResourceLocation dimensionID = dimensionKey.m_135782_();
        Set<ResourceLocation> dimension_whitelist = this.getWhitelistedDimensions();
        if (dimension_whitelist.contains(dimensionID)) {
            return this.exposedPlace(serverLevel.m_7328_(), ctx.m_191831_(), new ChunkPos(pos), null);
        }
        return false;
    }

    private Set<ResourceLocation> getWhitelistedDimensions() {
        IGServerConfig.Ores.OreConfig config = IGServerConfig.ORES.ores.get(this.entry);
        return ((List)config.dimension_whitelist.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
    }
}

