/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.world.features.helper.noise;

import com.igteam.immersivegeology.common.world.features.helper.noise.IGenerationPattern;
import com.igteam.immersivegeology.common.world.noise.INoise3D;
import com.igteam.immersivegeology.common.world.noise.SimplexNoise3D;

public class GenerationTubedNoise
implements IGenerationPattern {
    @Override
    public INoise3D getiNoise3D(int featureSize, long seed) {
        SimplexNoise3D warpSimplex = new SimplexNoise3D(seed - 1L);
        INoise3D warp = (x, y, z) -> warpSimplex.octaves(2, 0.5f).sinWarp(1.5f, 0.8f).flattened(-1.0f, 1.0f).bias(-0.1f).noise(x / 24.0f, y / 64.0f, z / 24.0f);
        float tubeCellSize = Math.max(20, 50 - featureSize);
        float wallThickness = 5.0f;
        float falloff = 1.0f;
        SimplexNoise3D wobbleSimplex = new SimplexNoise3D(seed + 1000L);
        INoise3D wobbleNoise = (x, y, z) -> wobbleSimplex.octaves(1, 0.7f).flattened(-1.0f, 1.0f).noise(x, y, z);
        return (x, y, z) -> {
            float tubeMidRadius = 8.0f * (0.75f + 0.75f * warp.noise(x, y, z));
            float innerEdge = tubeMidRadius - 2.5f;
            float outerEdge = tubeMidRadius + 2.5f;
            int cellX = (int)Math.floor(x / tubeCellSize);
            int cellZ = (int)Math.floor(z / tubeCellSize);
            float minDist = Float.MAX_VALUE;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    float wobbleZ;
                    float candidateCenterZ;
                    float dz;
                    int neighborX = cellX + i;
                    int neighborZ = cellZ + j;
                    float offsetX = this.pseudoRandom(neighborX, neighborZ, seed) * tubeCellSize;
                    float offsetZ = this.pseudoRandom(neighborX, neighborZ, seed + 1L) * tubeCellSize;
                    float baseCenterX = (float)neighborX * tubeCellSize + offsetX;
                    float baseCenterZ = (float)neighborZ * tubeCellSize + offsetZ;
                    float wobbleAmount = 3.0f;
                    float wobbleX = wobbleNoise.noise(baseCenterX / 50.0f, y / 50.0f, baseCenterZ / 50.0f) * wobbleAmount;
                    float candidateCenterX = baseCenterX + wobbleX;
                    float dx = x - candidateCenterX;
                    float d = (float)Math.sqrt(dx * dx + (dz = z - (candidateCenterZ = baseCenterZ + (wobbleZ = wobbleNoise.noise(baseCenterX / 50.0f, y / 50.0f, baseCenterZ / 50.0f + 100.0f) * wobbleAmount))) * dz);
                    if (!(d < minDist)) continue;
                    minDist = d;
                }
            }
            float densityInner = this.smoothStep(innerEdge, innerEdge + 1.0f, minDist);
            float densityOuter = this.smoothStep(outerEdge - 1.0f, outerEdge, minDist);
            float tubeDensity = densityInner - densityOuter;
            float verticalVariation = (float)(Math.sin((double)y / 16.0) * (double)0.2f) + 1.0f + 0.5f * warp.noise(x, y, z);
            float twist = warp.noise(x / 32.0f, y / 8.0f, z / 32.0f) + 1.0f;
            float product = tubeDensity * verticalVariation * twist;
            float result = product * 2.0f - 1.0f;
            return result;
        };
    }

    private float smoothStep(float edge0, float edge1, float x) {
        float t = this.clamp((x - edge0) / (edge1 - edge0), 0.0f, 1.0f);
        return t * t * (3.0f - 2.0f * t);
    }

    private float clamp(float x, float min, float max) {
        return Math.max(min, Math.min(max, x));
    }

    private float pseudoRandom(int x, int z, long seed) {
        int n = x * 374761393 + z * 668265263 + (int)seed * 15485863;
        n = (n ^ n >> 13) * 1274126177;
        n ^= n >> 16;
        return (float)(n & Integer.MAX_VALUE) / 2.1474836E9f;
    }
}

