/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.world.noise;

import net.minecraft.core.BlockPos;

@FunctionalInterface
public interface INoise3D {
    public float noise(float var1, float var2, float var3);

    default public float noise(BlockPos pos) {
        return this.noise(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    default public INoise3D octaves(int octaves) {
        return this.octaves(octaves, 0.5f);
    }

    default public INoise3D min(INoise3D other) {
        return (x, y, z) -> Math.min(this.noise(x, y, z), other.noise(x, y, z));
    }

    default public INoise3D subtractAndMin(INoise3D other) {
        return (x, y, z) -> {
            float original = this.noise(x, y, z);
            float subtracted = original - other.noise(x, y, z);
            return Math.min(original, subtracted);
        };
    }

    default public INoise3D octaves(int octaves, float persistence) {
        float[] frequency = new float[octaves];
        float[] amplitude = new float[octaves];
        for (int i = 0; i < octaves; ++i) {
            frequency[i] = 1 << i;
            amplitude[i] = (float)Math.pow(persistence, octaves - i);
        }
        return (x, y, z) -> {
            float value = 0.0f;
            for (int i = 0; i < octaves; ++i) {
                value += this.noise(x / frequency[i], y / frequency[i], z / frequency[i]) * amplitude[i];
            }
            return value;
        };
    }

    default public INoise3D ridged() {
        return (x, y, z) -> {
            float value = this.noise(x, y, z);
            value = value < 0.0f ? -value : value;
            return 1.0f - 2.0f * value;
        };
    }

    default public INoise3D terraces(int levels) {
        return (x, y, z) -> {
            float value = 0.5f * this.noise(x, y, z) + 0.5f;
            float rounded = (int)(value * (float)levels);
            return rounded * 2.0f / (float)levels - 1.0f;
        };
    }

    default public INoise3D spread(float scaleFactor) {
        return (x, y, z) -> this.noise(x * scaleFactor, y * scaleFactor, z * scaleFactor);
    }

    default public INoise3D warped(INoise3D warpX, INoise3D warpY, INoise3D warpZ) {
        return (x, y, z) -> {
            float x0 = x + warpX.noise(x, y, z);
            float y0 = y + warpY.noise(x, y, z);
            float z0 = z + warpZ.noise(x, y, z);
            return this.noise(x0, y0, z0);
        };
    }

    default public INoise3D flattened(float min, float max) {
        return (x, y, z) -> {
            float noise = this.noise(x, y, z);
            return noise > max ? max : (noise < min ? min : noise);
        };
    }

    default public INoise3D scale(float factor) {
        return (x, y, z) -> this.noise(x, y, z) * factor;
    }

    default public INoise3D gap(INoise3D other) {
        return (x, y, z) -> other.noise(x, y, z) > 0.0f ? -1.0f : this.noise(x, y, z) - other.noise(x, y, z);
    }

    default public INoise3D bias(float offset) {
        return (x, y, z) -> this.noise(x, y, z) + offset;
    }

    default public INoise3D add(INoise3D other) {
        return (x, y, z) -> this.noise(x, y, z) + other.noise(x, y, z);
    }

    default public INoise3D abs() {
        return (x, y, z) -> Math.abs(this.noise(x, y, z));
    }

    default public INoise3D invert() {
        return (x, y, z) -> -this.noise(x, y, z);
    }

    default public INoise3D power(float exponent) {
        return (x, y, z) -> (float)Math.pow(this.noise(x, y, z), exponent);
    }

    default public INoise3D multiply(INoise3D other) {
        return (x, y, z) -> this.noise(x, y, z) * other.noise(x, y, z);
    }

    default public INoise3D blend(INoise3D other, float alpha) {
        return (x, y, z) -> {
            float thisNoise = this.noise(x, y, z);
            float otherNoise = other.noise(x, y, z);
            return thisNoise * (1.0f - alpha) + otherNoise * alpha;
        };
    }

    default public INoise3D sub(INoise3D other) {
        return (x, y, z) -> this.noise(x, y, z) - other.noise(x, y, z);
    }

    default public INoise3D sinWarp(float frequency, float amplitude) {
        return (x, y, z) -> {
            float noise = this.noise(x, y, z);
            return (float)Math.sin(noise * frequency) * amplitude;
        };
    }

    default public INoise3D mirror(float planeX, float planeY, float planeZ) {
        return (x, y, z) -> {
            float mirroredX = 2.0f * planeX - x;
            float mirroredY = 2.0f * planeY - y;
            float mirroredZ = 2.0f * planeZ - z;
            return this.noise(mirroredX, mirroredY, mirroredZ);
        };
    }
}

