/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.world.noise;

public class NoiseUtil {
    private NoiseUtil() {
    }

    public static float simplexNoiseOffsetByPercent(float baseNoise, float percent) {
        float currNoise;
        float currCDFPercent = 0.0f;
        float basePercent = baseNoise == -1.0f ? 0.0f : NoiseUtil.noiseToCDF(baseNoise);
        for (currNoise = baseNoise; currCDFPercent < percent && currNoise < 1.0f; currNoise += 0.01f) {
            currCDFPercent = NoiseUtil.noiseToCDF(currNoise) - basePercent;
        }
        return currNoise - 0.01f;
    }

    public static float simplexNoiseNegativeOffsetByPercent(float baseNoise, float percent) {
        float currNoise;
        float basePercent;
        float currCDFPercent = 0.0f;
        float f = basePercent = baseNoise == 1.0f ? 1.0f : NoiseUtil.noiseToCDF(baseNoise);
        for (currNoise = baseNoise; currCDFPercent < percent && currNoise > -1.0f; currNoise -= 0.01f) {
            currCDFPercent = basePercent - NoiseUtil.noiseToCDF(currNoise);
        }
        return currNoise + 0.01f;
    }

    public static float noiseToCDF(float x) {
        return -0.435999f * x * x * x + 3.03E-4f * x * x + 0.916298f * x + 0.499721f;
    }

    public static float lerp(float start, float end, float t) {
        return start * (1.0f - t) + end * t;
    }

    public static int fastFloor(float f) {
        return f < 0.0f ? (int)f - 1 : (int)f;
    }

    public static int fastRound(float f) {
        return f >= 0.0f ? (int)(f + 0.5f) : (int)(f - 0.5f);
    }

    public static int hash(long seed, int x, int y) {
        seed ^= (long)(1619 * x);
        seed ^= (long)(31337 * y);
        seed = seed * seed * seed * 60493L;
        seed = seed >> 13 ^ seed;
        return (int)seed;
    }

    public static int hash(long seed, int x, int y, int z) {
        seed ^= (long)(1619 * x);
        seed ^= (long)(31337 * y);
        seed ^= (long)(6971 * z);
        seed = seed * seed * seed * 60493L;
        seed = seed >> 13 ^ seed;
        return (int)seed;
    }
}

