/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.world.noise;

import com.igteam.immersivegeology.common.world.noise.AbstractSimplexNoise;
import com.igteam.immersivegeology.common.world.noise.INoise3D;
import com.igteam.immersivegeology.common.world.noise.NoiseUtil;
import com.igteam.immersivegeology.common.world.noise.Vec3;

public class SimplexNoise3D
extends AbstractSimplexNoise
implements INoise3D {
    private static final float F3 = 0.33333334f;
    private static final float G3 = 0.16666667f;
    private static final Vec3[] VECTORS_3D = new Vec3[]{new Vec3(1.0f, 1.0f, 0.0f), new Vec3(-1.0f, 1.0f, 0.0f), new Vec3(1.0f, -1.0f, 0.0f), new Vec3(-1.0f, -1.0f, 0.0f), new Vec3(1.0f, 0.0f, 1.0f), new Vec3(-1.0f, 0.0f, 1.0f), new Vec3(1.0f, 0.0f, -1.0f), new Vec3(-1.0f, 0.0f, -1.0f), new Vec3(0.0f, 1.0f, 1.0f), new Vec3(0.0f, -1.0f, 1.0f), new Vec3(0.0f, 1.0f, -1.0f), new Vec3(0.0f, -1.0f, -1.0f)};

    public SimplexNoise3D(long seed) {
        super(seed);
    }

    @Override
    public float noise(float x, float y, float z) {
        float n3;
        float n2;
        float n1;
        float n0;
        int k2;
        int j2;
        int i2;
        int k1;
        int j1;
        int i1;
        float s = (x + y + z) * 0.33333334f;
        int i = NoiseUtil.fastFloor(x + s);
        int j = NoiseUtil.fastFloor(y + s);
        int k = NoiseUtil.fastFloor(z + s);
        float t = (float)(i + j + k) * 0.16666667f;
        float X0 = (float)i - t;
        float Y0 = (float)j - t;
        float Z0 = (float)k - t;
        float x0 = x - X0;
        float y0 = y - Y0;
        float z0 = z - Z0;
        if (x0 >= y0) {
            if (y0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 1;
                k2 = 0;
            } else if (x0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            } else {
                i1 = 0;
                j1 = 0;
                k1 = 1;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            }
        } else if (y0 < z0) {
            i1 = 0;
            j1 = 0;
            k1 = 1;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else if (x0 < z0) {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 1;
            j2 = 1;
            k2 = 0;
        }
        float x1 = x0 - (float)i1 + 0.16666667f;
        float y1 = y0 - (float)j1 + 0.16666667f;
        float z1 = z0 - (float)k1 + 0.16666667f;
        float x2 = x0 - (float)i2 + 0.33333334f;
        float y2 = y0 - (float)j2 + 0.33333334f;
        float z2 = z0 - (float)k2 + 0.33333334f;
        float x3 = x0 - 1.0f + 0.5f;
        float y3 = y0 - 1.0f + 0.5f;
        float z3 = z0 - 1.0f + 0.5f;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        int kk = k & 0xFF;
        short gi0 = this.permutationsMod12[ii + this.permutations[jj + this.permutations[kk]]];
        short gi1 = this.permutationsMod12[ii + i1 + this.permutations[jj + j1 + this.permutations[kk + k1]]];
        short gi2 = this.permutationsMod12[ii + i2 + this.permutations[jj + j2 + this.permutations[kk + k2]]];
        short gi3 = this.permutationsMod12[ii + 1 + this.permutations[jj + 1 + this.permutations[kk + 1]]];
        float t0 = 0.6f - x0 * x0 - y0 * y0 - z0 * z0;
        if (t0 < 0.0f) {
            n0 = 0.0f;
        } else {
            t0 *= t0;
            n0 = t0 * t0 * VECTORS_3D[gi0].dot(x0, y0, z0);
        }
        float t1 = 0.6f - x1 * x1 - y1 * y1 - z1 * z1;
        if (t1 < 0.0f) {
            n1 = 0.0f;
        } else {
            t1 *= t1;
            n1 = t1 * t1 * VECTORS_3D[gi1].dot(x1, y1, z1);
        }
        float t2 = 0.6f - x2 * x2 - y2 * y2 - z2 * z2;
        if (t2 < 0.0f) {
            n2 = 0.0f;
        } else {
            t2 *= t2;
            n2 = t2 * t2 * VECTORS_3D[gi2].dot(x2, y2, z2);
        }
        float t3 = 0.6f - x3 * x3 - y3 * y3 - z3 * z3;
        if (t3 < 0.0f) {
            n3 = 0.0f;
        } else {
            t3 *= t3;
            n3 = t3 * t3 * VECTORS_3D[gi3].dot(x3, y3, z3);
        }
        return 32.0f * (n0 + n1 + n2 + n3);
    }
}

