/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.world.structure;

import com.igteam.immersivegeology.common.world.IGStructureTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class HydroVent
extends Structure {
    public static final Codec<HydroVent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)HydroVent.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.intRange((int)-61, (int)80).fieldOf("y_min").forGetter(structure -> structure.ymin), (App)Codec.intRange((int)-31, (int)110).fieldOf("y_max").forGetter(structure -> structure.ymax), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, HydroVent::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final int size;
    private final int ymin;
    private final int ymax;
    private final int maxDistanceFromCenter;

    public HydroVent(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int size, int ymin, int ymax, int maxDistanceFromCenter) {
        super(settings);
        this.startPool = startPool;
        this.size = size;
        this.ymin = ymin;
        this.ymax = ymax;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), 0, chunkPos.m_45605_());
        int height = context.f_226622_().m_223235_(blockPos.m_123341_(), blockPos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_());
        BlockPos structurePos = new BlockPos(blockPos.m_123341_(), height, blockPos.m_123343_());
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, Optional.empty(), (int)this.size, (BlockPos)structurePos, (boolean)false, Optional.empty(), (int)this.maxDistanceFromCenter);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)IGStructureTypes.SO2_VENT_TYPE.get();
    }
}

