/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.enums;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import com.igteam.immersivegeology.core.material.data.chemical.MaterialAmmoniaSolution;
import com.igteam.immersivegeology.core.material.data.chemical.MaterialAquaRegia;
import com.igteam.immersivegeology.core.material.data.chemical.MaterialBindingAgent;
import com.igteam.immersivegeology.core.material.data.chemical.MaterialBrine;
import com.igteam.immersivegeology.core.material.data.chemical.MaterialChemicalWaste;
import com.igteam.immersivegeology.core.material.data.chemical.MaterialHydrochloricAcid;
import com.igteam.immersivegeology.core.material.data.chemical.MaterialHydrofluoricAcid;
import com.igteam.immersivegeology.core.material.data.chemical.MaterialHydrogenSulfide;
import com.igteam.immersivegeology.core.material.data.chemical.MaterialNitricAcid;
import com.igteam.immersivegeology.core.material.data.chemical.MaterialPhosphoricAcid;
import com.igteam.immersivegeology.core.material.data.chemical.MaterialSodiumHydroxide;
import com.igteam.immersivegeology.core.material.data.chemical.MaterialSulfurDioxide;
import com.igteam.immersivegeology.core.material.data.chemical.MaterialSulfuricAcid;
import com.igteam.immersivegeology.core.material.data.types.MaterialChemical;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public enum ChemicalEnum implements MaterialInterface<MaterialChemical>
{
    SulfuricAcid(new MaterialSulfuricAcid()),
    SulfurDioxde(new MaterialSulfurDioxide()),
    HydrogenSulfide(new MaterialHydrogenSulfide()),
    Brine(new MaterialBrine()),
    BindingAgent(new MaterialBindingAgent()),
    HydrochloricAcid(new MaterialHydrochloricAcid()),
    HydrofluoricAcid(new MaterialHydrofluoricAcid()),
    NitricAcid(new MaterialNitricAcid()),
    SodiumHydroxide(new MaterialSodiumHydroxide()),
    AquaRegia(new MaterialAquaRegia()),
    Ammonia(new MaterialAmmoniaSolution()),
    ChemicalWaste(new MaterialChemicalWaste()),
    PhosphoricAcid(new MaterialPhosphoricAcid());

    private final MaterialChemical material;

    private ChemicalEnum(MaterialChemical m) {
        this.material = m;
    }

    public static int getChemicalDamage(FluidTagInput fluidTagInput) {
        FluidTagInput base = new FluidTagInput(HydrochloricAcid.getFluidTag(), fluidTagInput.getAmount());
        boolean isBase = base.serialize().toString().equals(fluidTagInput.serialize().toString());
        if (isBase) {
            return 1;
        }
        return 0;
    }

    private List<Fluid> getAllCloudySlurries() {
        return this.instance().getValidSlurryMaterials().stream().map(m -> this.instance().getFluid(BlockCategoryFlags.CLOUDY_SLURRY, (MaterialInterface<?>)m)).toList();
    }

    private List<Fluid> getAllSlurries() {
        return this.instance().getValidSlurryMaterials().stream().map(m -> this.instance().getFluid(BlockCategoryFlags.SLURRY, (MaterialInterface<?>)m)).toList();
    }

    @Override
    public MaterialChemical instance() {
        return this.material;
    }

    public Fluid getSlurryWith(MaterialInterface<?> metalEnum) {
        return this.material.getFluid(BlockCategoryFlags.SLURRY, metalEnum);
    }

    public Fluid getSlurryWith(MaterialHelper helper) {
        return this.material.getFluid(BlockCategoryFlags.SLURRY, helper);
    }

    public FluidStack getSlurryWith(MaterialInterface<?> metalEnum, int amount) {
        return new FluidStack(this.getSlurryWith(metalEnum), amount);
    }

    public TagKey<Fluid> getCloudySlurryTagWith(MaterialInterface<?> metalEnum) {
        return this.getFluidTag(BlockCategoryFlags.CLOUDY_SLURRY, metalEnum);
    }

    public TagKey<Fluid> getCloudySlurryTagWith(MaterialHelper helper) {
        return this.getFluidTag(BlockCategoryFlags.CLOUDY_SLURRY, helper);
    }

    public Fluid getCloudySlurryWith(MaterialInterface<?> metalEnum) {
        return this.material.getFluid(BlockCategoryFlags.CLOUDY_SLURRY, metalEnum);
    }

    public Fluid getCloudySlurryWith(MaterialHelper helper) {
        return this.material.getFluid(BlockCategoryFlags.CLOUDY_SLURRY, helper);
    }

    public FluidStack getCloudySlurryWith(MaterialInterface<?> metalEnum, int amount) {
        return new FluidStack(this.getCloudySlurryWith(metalEnum), amount);
    }

    public TagKey<Fluid> getSlurryTagWith(BlockCategoryFlags type, MaterialInterface<?> material) {
        return this.getFluidTag(type, material);
    }

    public TagKey<Fluid> getSlurryTagWith(BlockCategoryFlags type, MaterialHelper helper) {
        return this.getFluidTag(type, helper);
    }

    public TagKey<Fluid> getSlurryTagWith(MaterialInterface<?> material) {
        return this.getFluidTag(BlockCategoryFlags.SLURRY, material);
    }

    public boolean hasSlurryWith(MaterialInterface<?> material) {
        return this.instance().hasSlurryWith(material);
    }

    public FluidStack getFluidStack(int i) {
        return new FluidStack(this.getFluid(BlockCategoryFlags.FLUID), i);
    }

    public boolean hasComplexNamingScheme() {
        return this.instance().hasComplexNamingScheme();
    }
}

