/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.enums;

import com.igteam.immersivegeology.common.block.helper.IOreBlock;
import com.igteam.immersivegeology.common.block.helper.MineralWeathering;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.common.world.IWorldGenConfig;
import com.igteam.immersivegeology.common.world.features.IGOreFeature;
import com.igteam.immersivegeology.core.material.data.chemical.mantle.MaterialMoltenMantle;
import com.igteam.immersivegeology.core.material.data.enums.StoneEnum;
import com.igteam.immersivegeology.core.material.data.metal.MaterialAluminum;
import com.igteam.immersivegeology.core.material.data.metal.MaterialBronze;
import com.igteam.immersivegeology.core.material.data.metal.MaterialCalcium;
import com.igteam.immersivegeology.core.material.data.metal.MaterialChromium;
import com.igteam.immersivegeology.core.material.data.metal.MaterialCobalt;
import com.igteam.immersivegeology.core.material.data.metal.MaterialCopper;
import com.igteam.immersivegeology.core.material.data.metal.MaterialGold;
import com.igteam.immersivegeology.core.material.data.metal.MaterialHastelloy;
import com.igteam.immersivegeology.core.material.data.metal.MaterialHighSpeedSteel;
import com.igteam.immersivegeology.core.material.data.metal.MaterialIron;
import com.igteam.immersivegeology.core.material.data.metal.MaterialLead;
import com.igteam.immersivegeology.core.material.data.metal.MaterialMagnesium;
import com.igteam.immersivegeology.core.material.data.metal.MaterialManganese;
import com.igteam.immersivegeology.core.material.data.metal.MaterialMolybdenum;
import com.igteam.immersivegeology.core.material.data.metal.MaterialNeodymium;
import com.igteam.immersivegeology.core.material.data.metal.MaterialNickel;
import com.igteam.immersivegeology.core.material.data.metal.MaterialOsmium;
import com.igteam.immersivegeology.core.material.data.metal.MaterialPlatinum;
import com.igteam.immersivegeology.core.material.data.metal.MaterialRefinedUranium;
import com.igteam.immersivegeology.core.material.data.metal.MaterialSilver;
import com.igteam.immersivegeology.core.material.data.metal.MaterialSodium;
import com.igteam.immersivegeology.core.material.data.metal.MaterialStainlessSteel;
import com.igteam.immersivegeology.core.material.data.metal.MaterialSteel;
import com.igteam.immersivegeology.core.material.data.metal.MaterialThorium;
import com.igteam.immersivegeology.core.material.data.metal.MaterialTin;
import com.igteam.immersivegeology.core.material.data.metal.MaterialTitanium;
import com.igteam.immersivegeology.core.material.data.metal.MaterialTungsten;
import com.igteam.immersivegeology.core.material.data.metal.MaterialTungstenCarbide;
import com.igteam.immersivegeology.core.material.data.metal.MaterialUnobtanium;
import com.igteam.immersivegeology.core.material.data.metal.MaterialUranium;
import com.igteam.immersivegeology.core.material.data.metal.MaterialVanadium;
import com.igteam.immersivegeology.core.material.data.metal.MaterialZinc;
import com.igteam.immersivegeology.core.material.data.metal.MaterialZirconium;
import com.igteam.immersivegeology.core.material.data.types.MaterialMetal;
import com.igteam.immersivegeology.core.material.helper.ScaffoldingHelper;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public enum MetalEnum implements MaterialInterface<MaterialMetal>,
IWorldGenConfig
{
    Aluminum(new MaterialAluminum()),
    Bronze(new MaterialBronze()),
    Calcium(new MaterialCalcium()),
    Chromium(new MaterialChromium()),
    Cobalt(new MaterialCobalt()),
    Copper(new MaterialCopper()),
    Gold(new MaterialGold()),
    Iron(new MaterialIron()),
    Lead(new MaterialLead()),
    Manganese(new MaterialManganese()),
    Magnesium(new MaterialMagnesium()),
    Molybdenum(new MaterialMolybdenum()),
    Neodymium(new MaterialNeodymium()),
    Nickel(new MaterialNickel()),
    Osmium(new MaterialOsmium()),
    Platinum(new MaterialPlatinum()),
    Hastelloy(new MaterialHastelloy()),
    HighSpeedSteel(new MaterialHighSpeedSteel()),
    Silver(new MaterialSilver()),
    Steel(new MaterialSteel()),
    StainlessSteel(new MaterialStainlessSteel()),
    Sodium(new MaterialSodium()),
    Thorium(new MaterialThorium()),
    Tin(new MaterialTin()),
    Titanium(new MaterialTitanium()),
    Tungsten(new MaterialTungsten()),
    Unobtanium(new MaterialUnobtanium()),
    Uranium(new MaterialUranium()),
    RefinedUranium(new MaterialRefinedUranium()),
    Vanadium(new MaterialVanadium()),
    Zinc(new MaterialZinc()),
    Zirconium(new MaterialZirconium()),
    TungstenCarbide(new MaterialTungstenCarbide()),
    MoltenMantle(new MaterialMoltenMantle());

    private final MaterialMetal material;

    public static List<? extends IWorldGenConfig> nativeMetals() {
        return Arrays.stream(MetalEnum.values()).filter(v -> v.hasFlag(BlockCategoryFlags.ORE_BLOCK)).toList();
    }

    public static List<MetalEnum> generatedNativeMetals() {
        return Arrays.stream(MetalEnum.values()).filter(v -> v.hasFlag(BlockCategoryFlags.ORE_BLOCK)).toList();
    }

    public static List<? extends IWorldGenConfig> scaffoldingMetals() {
        return Arrays.stream(MetalEnum.values()).filter(v -> v.hasFlag(BlockCategoryFlags.SCAFFOLDING)).toList();
    }

    public static List<String> getAtlasPermutations() {
        ArrayList<String> permutations = new ArrayList<String>();
        for (MetalEnum metal : MetalEnum.values()) {
            for (MineralWeathering weathering : MineralWeathering.values()) {
                permutations.add(metal.getName() + "/" + weathering.name().toLowerCase());
            }
        }
        return permutations;
    }

    public static List<String> getAtlasScaffoldingPermutations() {
        ArrayList<String> permutations = new ArrayList<String>();
        MetalEnum.scaffoldingMetals().forEach(e -> permutations.add(e.getName() + "/" + MineralWeathering.PRISTINE.name().toLowerCase()));
        return permutations;
    }

    private MetalEnum(MaterialMetal m) {
        this.material = m;
    }

    @Override
    public MaterialMetal instance() {
        return this.material;
    }

    @Override
    public String getName() {
        return this.material.getName();
    }

    @Override
    public double getAssociateMaterialChance() {
        return this.material.getAssociateMaterialChance();
    }

    @Override
    public Set<Pair<Function<Integer, MaterialHelper>, Integer>> getAssociateMaterialSet() {
        return this.instance().getAssociateMaterialSet();
    }

    @Override
    public int getVeinSize() {
        return this.material.CONFIG.veinSize();
    }

    @Override
    public int getMinY() {
        return this.material.CONFIG.minY();
    }

    @Override
    public int getMaxY() {
        return this.material.CONFIG.maxY();
    }

    @Override
    public boolean useSparsePlacement() {
        return this.material.CONFIG.useSparsePlacement();
    }

    @Override
    public int veinsPerChunk() {
        return this.material.CONFIG.veinsPerChunk();
    }

    @Override
    public int rarity() {
        return this.material.CONFIG.rarity();
    }

    @Override
    public Optional<TagKey<Biome>> getPreferredBiome() {
        return this.material.CONFIG.preferredBiome();
    }

    @Override
    public IOreBlock getOreBlock(StoneEnum stone, OreRichness richness) {
        return this.material.getOreBlock(stone, richness);
    }

    @Override
    public BlockState getDefaultBlockstate() {
        return null;
    }

    @Override
    public IOreBlock getOreBlock(MaterialHelper stone, OreRichness richness) {
        return this.material.getOreBlock(stone, richness);
    }

    @Override
    public int generationChance() {
        return this.material.CONFIG.generationChance();
    }

    @Override
    public double density() {
        return this.material.CONFIG.density();
    }

    public ScaffoldingHelper getScaffoldingBlock() {
        return this.instance().getScaffoldingBlock();
    }

    @Override
    public double getMinSpawnTemp() {
        return -1.0;
    }

    @Override
    public double getMaxSpawnTemp() {
        return 2.0;
    }

    @Override
    public double getMinDownfall() {
        return 0.0;
    }

    @Override
    public double getMaxDownfall() {
        return 1.0;
    }

    @Override
    public IWorldGenConfig getConfig() {
        return this;
    }

    @Override
    public long seed() {
        return IGOreFeature.IGOreFeatureConfig.hash(this.name());
    }
}

