/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.enums;

import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialAndesite;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialBasalt;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialChalk;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialChert;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialClaystone;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialConglomerate;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialDacite;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialDiorite;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialDolomite;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialGabbro;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialGneiss;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialGranite;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialLimestone;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialMarble;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialPhyllite;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialQuartzite;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialRhyolite;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialSchist;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialShale;
import com.igteam.immersivegeology.core.material.data.stone.compat.tfc.MaterialSlate;
import com.igteam.immersivegeology.core.material.data.stone.vanilla.MaterialMCAndesite;
import com.igteam.immersivegeology.core.material.data.stone.vanilla.MaterialMCBasalt;
import com.igteam.immersivegeology.core.material.data.stone.vanilla.MaterialMCDeepslate;
import com.igteam.immersivegeology.core.material.data.stone.vanilla.MaterialMCDiorite;
import com.igteam.immersivegeology.core.material.data.stone.vanilla.MaterialMCDripstone;
import com.igteam.immersivegeology.core.material.data.stone.vanilla.MaterialMCEndStone;
import com.igteam.immersivegeology.core.material.data.stone.vanilla.MaterialMCGranite;
import com.igteam.immersivegeology.core.material.data.stone.vanilla.MaterialMCNetherrack;
import com.igteam.immersivegeology.core.material.data.stone.vanilla.MaterialMCSandstone;
import com.igteam.immersivegeology.core.material.data.stone.vanilla.MaterialVanilla;
import com.igteam.immersivegeology.core.material.data.types.MaterialStone;
import com.igteam.immersivegeology.core.material.helper.flags.ModFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public enum StoneEnum implements MaterialInterface<MaterialStone>
{
    Andesite(new MaterialAndesite()),
    Basalt(new MaterialBasalt()),
    Dacite(new MaterialDacite()),
    Rhyolite(new MaterialRhyolite()),
    Diorite(new MaterialDiorite()),
    Gabbro(new MaterialGabbro()),
    Granite(new MaterialGranite()),
    Gneiss(new MaterialGneiss()),
    Marble(new MaterialMarble()),
    Phyllite(new MaterialPhyllite()),
    Quartzite(new MaterialQuartzite()),
    Schist(new MaterialSchist()),
    Slate(new MaterialSlate()),
    Chalk(new MaterialChalk()),
    Chert(new MaterialChert()),
    Claystone(new MaterialClaystone()),
    Conglomerate(new MaterialConglomerate()),
    Dolomite(new MaterialDolomite()),
    Limestone(new MaterialLimestone()),
    Shale(new MaterialShale()),
    MCStone(new MaterialVanilla()),
    MCDeepslate(new MaterialMCDeepslate()),
    MCAndesite(new MaterialMCAndesite()),
    MCDiorite(new MaterialMCDiorite()),
    MCGranite(new MaterialMCGranite()),
    MCBasalt(new MaterialMCBasalt()),
    MCEndStone(new MaterialMCEndStone()),
    MCNetherrack(new MaterialMCNetherrack()),
    MCDripstone(new MaterialMCDripstone()),
    MCSandstone(new MaterialMCSandstone());

    public static final Codec<StoneEnum> CODEC;
    private static final Map<String, StoneEnum> stoneEnumMap;
    private final MaterialStone material;

    private StoneEnum(MaterialStone m) {
        this.material = m;
    }

    public static StoneEnum selectWorldState(BlockState stoneState) {
        try {
            String name = stoneState.m_60734_().m_7705_().toLowerCase();
            String stoneName = StoneEnum.capitalizeFirstLetter(name.substring(name.lastIndexOf(46) + 1));
            if (name.contains(ModFlags.MINECRAFT.getName())) {
                return stoneEnumMap.get("mc" + stoneName.toLowerCase());
            }
            StoneEnum result = stoneEnumMap.get(stoneName.toLowerCase());
            if (result != null) {
                return result;
            }
        }
        catch (Exception ex) {
            IGLib.IG_LOGGER.warn("Unable to find matching stone type for ore {}", (Object)ex.getMessage());
        }
        return null;
    }

    private static String capitalizeFirstLetter(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    @Override
    public MaterialStone instance() {
        return this.material;
    }

    public List<OreConfiguration.TargetBlockState> getTargets(MineralEnum mineral) {
        return this.instance().getTargets(mineral);
    }

    public boolean isWorldState(BlockState stoneState) {
        return stoneState.m_60734_().m_49954_().getString().equalsIgnoreCase(this.material.getName());
    }

    public String getTFCStoneLoc() {
        return this.instance().getTFCStoneLoc();
    }

    public boolean isStoneTypeValid() {
        List<ModFlags> list = this.getFlags().stream().filter(f -> f instanceof ModFlags).map(flag -> (ModFlags)flag).toList();
        if (list.isEmpty()) {
            return true;
        }
        boolean pass = false;
        for (ModFlags flag2 : list) {
            pass = flag2.isStrictlyLoaded();
        }
        return pass;
    }

    public boolean isVanilla() {
        return this.getFlags().contains(ModFlags.MINECRAFT);
    }

    static {
        CODEC = Codec.STRING.xmap(StoneEnum::valueOf, Enum::name);
        stoneEnumMap = new HashMap<String, StoneEnum>();
        for (StoneEnum stoneEnum : StoneEnum.values()) {
            stoneEnumMap.put(stoneEnum.name().toLowerCase(), stoneEnum);
        }
    }
}

