/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.metal;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.data.types.MaterialNativeMetal;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.MaterialFlags;
import com.igteam.immersivegeology.core.material.helper.flags.ModFlags;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;

public class MaterialGold
extends MaterialNativeMetal {
    public MaterialGold() {
        this.addFlags(MaterialFlags.EXISTING_IMPLEMENTATION);
        this.addExistingFlag(ModFlags.MINECRAFT, ItemCategoryFlags.INGOT, ItemCategoryFlags.NUGGET);
        this.addExistingFlag(ModFlags.MINECRAFT, BlockCategoryFlags.STORAGE_BLOCK);
        this.addExistingFlag(ModFlags.IMMERSIVEENGINEERING, ItemCategoryFlags.ROD, ItemCategoryFlags.PLATE, ItemCategoryFlags.POWDER);
        this.addExistingFlag(ModFlags.TFC, BlockCategoryFlags.ORE_BLOCK);
        this.removeMaterialFlags(ItemCategoryFlags.METAL_OXIDE, ItemCategoryFlags.COMPOUND_DUST);
        this.acceptableStoneTypes.add(StoneFormation.NETHER_STONE);
        this.acceptableStoneTypes.add(StoneFormation.IGNEOUS_INTRUSIVE);
        this.acceptableStoneTypes.add(StoneFormation.MINECRAFT_STONE);
        this.CONFIG = new MaterialMineral.MineralConfig(33, 60, 1, -32, 64, 3108, 0.66, false, Optional.empty(), IGGenerationType.DEFAULT);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> -10496;
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGMethodBuilder.blasting(this, IGStageDesignation.EXTRACTION).create("crushed_ore_" + this.getName() + "_to_ingot", this.getItemTag(ItemCategoryFlags.CRUSHED_ORE), this.getPrimaryProduct().getStack(ItemCategoryFlags.INGOT));
        IGMethodBuilder.bloomery(this, IGStageDesignation.REFINEMENT).create(ItemCategoryFlags.CRUSHED_ORE, 2, ItemCategoryFlags.INGOT, 1, 200);
        IGMethodBuilder.chemical(this, IGStageDesignation.REFINEMENT).create(ItemCategoryFlags.CRUSHED_ORE, BlockCategoryFlags.SLURRY, ItemStack.f_41583_, ChemicalEnum.AquaRegia.getSlurryWith(MetalEnum.Gold, 432), IngredientWithSize.of((ItemStack)this.getStack(ItemCategoryFlags.CRUSHED_ORE, 1)), new FluidTagInput(ChemicalEnum.HydrochloricAcid.getFluidTag(BlockCategoryFlags.FLUID), 250), new FluidTagInput(ChemicalEnum.NitricAcid.getFluidTag(BlockCategoryFlags.FLUID), 250), null, 200, 51200);
        IGMethodBuilder.chemical(this, IGStageDesignation.REFINEMENT).create(ItemCategoryFlags.CRUSHED_ORE, BlockCategoryFlags.SLURRY, ItemStack.f_41583_, ChemicalEnum.AquaRegia.getSlurryWith(MetalEnum.Gold, 432), IngredientWithSize.of((ItemStack)this.getStack(ItemCategoryFlags.CRUSHED_ORE, 1)), new FluidTagInput(ChemicalEnum.AquaRegia.getFluidTag(BlockCategoryFlags.FLUID), 500), null, null, 200, 51200);
        IGMethodBuilder.crystallize(this, IGStageDesignation.CRYSTALLIZATION).create(ChemicalEnum.AquaRegia, ItemCategoryFlags.CRYSTAL);
        IGMethodBuilder.basicSmelting(this, IGStageDesignation.REFINEMENT).create(ItemCategoryFlags.GRIT, ItemCategoryFlags.INGOT, 120);
    }

    @Override
    public boolean hasCustomTexture(BlockCategoryFlags blockCategoryFlags) {
        return blockCategoryFlags.equals(BlockCategoryFlags.ORE_BLOCK);
    }

    @Override
    public float getNoiseProbability() {
        return 0.1942749f;
    }
}

