/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.mineral;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.CrystalFamily;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeNode;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;

public class MaterialBauxite
extends MaterialMineral {
    protected IGRecipeChain bayer_process = new IGRecipeChain(this, "Bayer process", 0);

    public MaterialBauxite() {
        this.acceptableStoneTypes.add(StoneFormation.SEDIMENTARY);
        this.acceptableStoneTypes.add(StoneFormation.MINECRAFT_STONE);
        this.CONFIG = new MaterialMineral.MineralConfig(30, 50, 1, -64, 180, 1470, 0.8, false, Optional.of(Tags.Biomes.IS_WET), IGGenerationType.DEFAULT);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> -6709329;
    }

    @Override
    public CrystalFamily getCrystalFamily() {
        return CrystalFamily.MONOCLINIC;
    }

    @Override
    public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return new LinkedHashSet(List.of(MetalEnum.Aluminum, MetalEnum.Iron));
    }

    @Override
    public void setupRecipeStages() {
        logged_recipes.add(this.getName());
        IGRecipeNode crushing = IGMethodBuilder.crushing(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.GRIT, 6000, 100).addToTree(this.bayer_process);
        IGRecipeNode powder_a = IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.POWDER).addOptionalToTree(this.bayer_process);
        IGRecipeNode powder_b = IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.GRIT, ItemCategoryFlags.POWDER, 400, 32000).addToTree(this.bayer_process, crushing);
        IGMethodBuilder.chemical(this, IGStageDesignation.LEECHING).create("ore_powder_" + this.getName() + "_to_slurry", ItemStack.f_41583_, new FluidStack(ChemicalEnum.SodiumHydroxide.getCloudySlurryWith(MineralEnum.Bauxite), 216), new IngredientWithSize(this.getItemTag(ItemCategoryFlags.POWDER), 1), new FluidTagInput(ChemicalEnum.SodiumHydroxide.getFluidTag(BlockCategoryFlags.FLUID), 250), null, null, 200, 51200).joinBranches(this.bayer_process, powder_a, powder_b);
        IGMethodBuilder.centrifuge(this, IGStageDesignation.REFINEMENT).create(ChemicalEnum.SodiumHydroxide.getCloudySlurryTagWith(MineralEnum.Bauxite), 144, MetalEnum.Aluminum, ItemCategoryFlags.COMPOUND_DUST, 1, ChemicalEnum.ChemicalWaste.getCloudySlurryWith(MineralEnum.Bauxite), 120, null, 0, 1200, 614400).addToTree(this.bayer_process);
        IGMethodBuilder.chemical(this, IGStageDesignation.LEECHING).create("waste_" + this.getName() + "_to_oxide", MetalEnum.Iron.getStack(ItemCategoryFlags.METAL_OXIDE), ChemicalEnum.ChemicalWaste.getFluidStack(250), new IngredientWithSize(MetalEnum.Calcium.getItemTag(ItemCategoryFlags.COMPOUND_DUST), 1), new FluidTagInput(ChemicalEnum.HydrochloricAcid.getFluidTag(BlockCategoryFlags.FLUID), 144), new FluidTagInput(ChemicalEnum.ChemicalWaste.getCloudySlurryTagWith(MineralEnum.Bauxite), 144), new FluidTagInput(ChemicalEnum.SulfuricAcid.getFluidTag(BlockCategoryFlags.FLUID), 144), 200, 51200).addToTree(this.bayer_process);
    }

    @Override
    public Set<IGRecipeChain> getRecipeChains() {
        return Set.of(this.bayer_process);
    }

    @Override
    public float getNoiseProbability() {
        return 0.20800781f;
    }
}

