/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.mineral;

import com.igteam.immersivegeology.common.block.helper.MineralWeathering;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.data.types.MaterialSulphideMineral;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.MaterialFlags;
import com.igteam.immersivegeology.core.material.helper.flags.ModFlags;
import com.igteam.immersivegeology.core.material.helper.material.CrystalFamily;
import com.igteam.immersivegeology.core.material.helper.material.MaterialColorHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.tags.BiomeTags;

public class MaterialChalcopyrite
extends MaterialSulphideMineral {
    Function<Integer, Integer> coloredWeathering = MaterialColorHelper.setupWeatheredColors(List.of(MaterialColorHelper.weatheredColor(MineralWeathering.PRISTINE, 10386239), MaterialColorHelper.weatheredColor(MineralWeathering.TARNISHED, 5008191)));

    public MaterialChalcopyrite() {
        this.acceptableStoneTypes.add(StoneFormation.IGNEOUS_INTRUSIVE);
        this.acceptableStoneTypes.add(StoneFormation.SEDIMENTARY);
        this.addFlags(ModFlags.TFC, MaterialFlags.EXISTING_IMPLEMENTATION);
        this.removeMaterialFlags(ItemCategoryFlags.GRIT);
        this.removeMaterialFlags(ItemCategoryFlags.POWDER);
        this.addFlags(ItemCategoryFlags.SLAG);
        this.addFlags(ItemCategoryFlags.POWDERED_SLAG);
        this.setAsocialMaterialChance(1.0f);
        this.addGenerationFriend(h -> MineralEnum.Pyrite.instance(), 50);
        this.addGenerationFriend(h -> MineralEnum.Chalcocite.instance(), 50);
        this.CONFIG = new MaterialMineral.MineralConfig(14, 35, 1, -64, 256, 350, 0.75, false, Optional.of(BiomeTags.f_207612_), IGGenerationType.TUBE);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> this.coloredWeathering.apply((Integer)i);
    }

    @Override
    public boolean canTarnish() {
        return true;
    }

    @Override
    public CrystalFamily getCrystalFamily() {
        return CrystalFamily.TETRAGONAL;
    }

    @Override
    public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return new LinkedHashSet(List.of(MetalEnum.Copper, MetalEnum.Iron));
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGMethodBuilder.roast(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, 1, ItemCategoryFlags.SLAG, 1, 800, 25).addToTree(this.sulphideElectrowining);
        IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.SLAG, ItemCategoryFlags.POWDERED_SLAG).addToTree(this.sulphideElectrowining);
        IGMethodBuilder.separating(this, IGStageDesignation.PURIFICATION).create(this.getItemTag(ItemCategoryFlags.POWDERED_SLAG), MetalEnum.Iron.getStack(ItemCategoryFlags.METAL_OXIDE), MetalEnum.Copper.getStack(ItemCategoryFlags.COMPOUND_DUST), 0.75f, 200, 250).addToTree(this.sulphideElectrowining);
        IGMethodBuilder.roast(this, IGStageDesignation.PURIFICATION).create("roast_copper_sulfide_to_oxide", MetalEnum.Copper.getItemTag(ItemCategoryFlags.COMPOUND_DUST), 1, MetalEnum.Copper.getStack(ItemCategoryFlags.METAL_OXIDE), 800, 120).addToTree(this.sulphideElectrowining);
    }

    @Override
    public Set<IGRecipeChain> getRecipeChains() {
        return Set.of(this.sulphideElectrowining);
    }

    @Override
    public float getNoiseProbability() {
        return 0.124816895f;
    }
}

